/***************************************************************************
                          listbox.cpp  -  description
                             -------------------
    begin                : Tue Mar 7 2000
    copyright            : (C) 2000 by Michael Sabielny
    email                : sabielny@tu-harburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "listbox.h"
#include <qstring.h>

// Constructor
ListBox::ListBox(QWidget *parent, const char *name ) : QListBox(parent,name) {

	// connect the signal highlighted with slotUserClicked
	connect(this,SIGNAL(highlighted(int)),SLOT(slotUserClicked(int)));
	
	// get the initial number of items in the list and send the signals
	slotEmitSignals();
}

// Destructor
ListBox::~ListBox(){
}

// Public Member Functions
void ListBox::appendNewEntry(const char* entryText){

	// insert entryText at the end of the list and increase the numberOfItems
	insertItem(entryText, -1);
	// auto-select the last added entry
	slotEmitSignals();
	setSelected( numberOfItems-1, TRUE);
}

void ListBox::removeCurrentEntry(){

	// remove the current selected item
	if ( remove )
	{			
		removeItem( highlightedItem );
		// emit the signals
		slotEmitSignals();
	}
}

void ListBox::removeAll(){

	// remove the first entry in the list
	if ( remove )
	{
		QListBox::clear();
		// emit the signals
		slotEmitSignals();
	}
}

void ListBox::moveCurrentEntryUp(){

	// move the current entry up
	if( moveUp )
	{
		int index = highlightedItem;
		// the upper item
		QString upper = text(index-1);
		// the lower item, which is the current item
		QString lower = text(index);
		// swapping the pointers
		changeItem(lower, index-1);
		changeItem(upper, index);
		// setting the current item
		setCurrentItem(index-1);
		// emit the signals
		slotEmitSignals();
	}
}

void ListBox::moveCurrentEntryDown(){

	// move the current entry down
	if ( moveDown )
	{
		int index = highlightedItem;
		// the upper item
		QString upper = text(index);
		// the lower item, which is the current item
		QString lower = text(index+1);
		// swapping the pointers
		changeItem(lower, index);
		changeItem(upper, index+1);
		// setting the current item
		setCurrentItem(index+1);
		// emit the signals
		slotEmitSignals();
	}
}

///////////////////////////////////////////////////////////
// Protected Member Functions

void ListBox::slotEmitSignals(){

	// this is the signal implementation of ListBox Class. After every Operation
	// on a child of this class, the signal emits according to the number of items
	// in the list and the current item
	
	highlightedItem = QListBox::currentItem();
	numberOfItems = QListBox::count();
	//debug("count = %i currentItem = %i",numberOfItems,highlightedItem);
	
	// now send the appropriate signals
	if ( highlightedItem == -1)
	{
		// there are no items in the list
		remove = FALSE;
		moveUp = FALSE;
		moveDown = FALSE;
	}
	else
	{
		// there are some items in the list
		remove = TRUE;
		// special treatment for move_up/move_down
		if ( highlightedItem > 0 )	
			{ moveUp = TRUE; }
		else
			{ moveUp = FALSE;}
			
		if ( highlightedItem < (numberOfItems-1) )
			{ moveDown = TRUE; }
		else
			{ moveDown = FALSE;}	
	}	
	
	// now emit the signals
	emit listBoxStatus(remove,moveUp,moveDown);
	if ( numberOfItems==0 )
		{emit listBoxHasItems(0,-1);}
	else
		{emit listBoxHasItems(1,-1);}
	//debug("remove %i | moveUp %i | moveDown %i",remove, moveUp,moveDown);
}

void ListBox::slotUserClicked(int dummy){

	// dummy has no function here
	// just rerun slotEmitSignals on clicking by the user
	slotEmitSignals();
}