/***************************************************************************
                          listbox.h  -  description
                             -------------------
    begin                : Tue Mar 7 2000
    copyright            : (C) 2000 by Michael Sabielny
    email                : sabielny@tu-harburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LISTBOX_H
#define LISTBOX_H

#include <qwidget.h>
#include <qlistbox.h>


class ListBox : public QListBox  {

   Q_OBJECT

public:	
	ListBox(QWidget *parent=0, const char *name=0);
	~ListBox();
	
	// appends a new Item to the ENd of the list
	void appendNewEntry(const char*);
	
	// removes the current entry
	void removeCurrentEntry();
	
	// removes all Entries in the list
	void removeAll();
	
	// moves the current entry up if possible
	void moveCurrentEntryUp();
	
	// moves the current entry down if possible
	void moveCurrentEntryDown();
	

signals:
	
	// emit this signal to show the status of the ListBox-Object
	// values: remove, moveUp, moveDown
	void listBoxStatus(bool, bool, bool);
	
	// emits (1, -1) if the listBos has items
	// emits (0, -1) if the listBox has no items
	void listBoxHasItems(int,int);

protected slots:

	// slot for emitting the signals
	void slotEmitSignals();	
	// slot for the item clicked by the user
	void slotUserClicked(int);
	
private:
	
	int numberOfItems;
	int highlightedItem;
	bool remove;
	bool moveUp;
	bool moveDown;
		
};

#endif
