// -*- C++ -*-
/* This file is part of
* ======================================================
* 
*           LyX, the High Level Document Processor
* 	 
*	    Copyright (C) 1997, The LyX Team.
*
*======================================================*/

#ifndef _BACK_STACK_H
#define _BACK_STACK_H

#include "LString.h"

// Created by Alejandro Aguilar Sierra, 970806

/**  Utility to get back from a reference or from a child document.
 */
class BackStack {
public:
	///
	struct BackStackItem {
		///
		void set(LString f, int xx, int yy) {
			fname = f;  x = xx;  y = yy;
		}
		/// Filename
		LString fname;
		/// Cursor x-position
		int x;
		/// Cursor y-position
		int y;   
	};
	///
	BackStack(int n): imax(n) {
		item = new BackStackItem[imax];
		i = 0;
	}
	///
	~BackStack() {
		delete[] item;
	}
	///
	void push(LString f, int x, int y) {
	  // Matthias
	  if (i>=imax){
	    int a;
	    for (a=0; a<imax-1; a++)
	      item[a].set(item[a+1].fname, 
			  item[a+1].x, 
			  item[a+1].y);
	    i--;
	  }
	  item[i++].set(f, x, y);
	}
	///
	LString &pop(int *x, int *y) {
		if (i>0) i--;
		*x = item[i].x;
		*y = item[i].y;
		return item[i].fname;
	}

	///
	  // Matthias
	bool isEmpty() {
		return (i <= 0 );
	}
private:
	///
	BackStackItem *item;
	///
	int i;
	///
	int imax;
};

#endif
