/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor 	 
 *	     Copyright (C) 1995 Matthias Ettrich
 *
 *           This file is Copyright (C) 1997
 *           Asger Alstrup
 *
 *======================================================
 */

#include <config.h>

#include <kapp.h>
#include <klocale.h>

#include <stdlib.h> // atoi
#include "Chktex.h"
#include "LaTeX.h" // TeXErrors
#include "filetools.h"
#include "lyxlex.h"
#include "FileInfo.h"
#include "error.h"
#include "syscall.h"
#include "syscontr.h"
#include "pathstack.h"

// 	$Id: Chktex.C,v 1.2 1999/01/05 11:16:27 kulow Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: Chktex.C,v 1.2 1999/01/05 11:16:27 kulow Exp $";
#endif /* lint */


/*
 * CLASS Chktex
 */

Chktex::Chktex(LString const & chktex, LString const & f, LString const & p)
		: cmd(chktex), file(f), path(p)
{
}


int Chktex::run(TeXErrors &terr)
{
	// run bibtex
	LString log = ChangeExtension(file, ".log", true);
	LString tmp = cmd + " -q -v0 -b0 -x " + file + " -o " + log;
        Systemcalls one;
	int result= one.Startscript(Systemcalls::System, tmp);
	if (result == 0) {
		result = scanLogFile(terr);
	} else {
		result = -1;
	}
	return result;
}


int Chktex::scanLogFile(TeXErrors &terr)
{
	LString token;
	int retval = 0;

	LyXLex lex(NULL, 0);

	LString tmp = ChangeExtension(file, ".log", true);

	if (!lex.setFile(tmp)) {
		// Unable to open file. Return at once
		return -1;
	}

	while (lex.IsOK()) {
		if (lex.EatLine())
			token = lex.GetString();
		else // blank line in the file being read
			continue;

		LString file, line, pos, warno, warning;
		token.split(file, ':');
		token.split(line, ':');
		token.split(pos, ':');
		token.split(warno, ':');
		token.split(warning, ':');

		int lineno = atoi(line.c_str());
		warno = i18n("ChkTeX warning id #") + warno;
		terr.insertError(lineno, warno, warning);
		retval++;
	}
	return retval;
}
