// This file is part of KLyX, The KDE Document Processor
//
// Copyright (C) 1995 Matthias Ettrich
// Copyright (C) 1997-1999 KLyX Team


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kfiledialog.h>

#include "EditFigureDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qbttngrp.h>
#include <qchkbox.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qradiobt.h>

#include <signal.h>
#include <unistd.h>
#include <stdlib.h>

#include "LyXView.h"
#include "figinset.h"
#include "LString.h"
#include "error.h"
#include "filetools.h"
#include "lyx_gui_misc.h"
#include "lyx_main.h"
#include "FileInfo.h"
#include "BufferView.h"
#include "lyxrc.h"
#include <qlayout.h>

extern void UpdateInset(Inset* inset, bool mark_dirty = true);
extern void addpidwait(int pid);
extern LyXRC* lyxrc;
extern void sigchldhandler(int sig);
extern BufferView* current_view;

EditFigureDialog::EditFigureDialog( LyXView *view, QWidget *parent=0,
				    const char *name=0, WFlags f=0 )
    : QDialog( parent, name, true, f ),
      _view( view )
{
  // toplevel
  QVBoxLayout *toplevelVL = new QVBoxLayout(this, 10, 3);
  // edit line
  QHBoxLayout *topHL = new QHBoxLayout(4);
  // body
  QHBoxLayout *bodyHL = new QHBoxLayout(4);
  // buttons
  QHBoxLayout *buttonHL = new QHBoxLayout(10);
  // right side
  QVBoxLayout *rightVL = new QVBoxLayout(2);
  // left side
  QGridLayout *leftGL = new QGridLayout(2, 2);

  toplevelVL->addLayout(topHL, 1);
  toplevelVL->addLayout(bodyHL, 3);

  bodyHL->addLayout(leftGL);
  bodyHL->addLayout(rightVL);

  epsfigureED = new QLineEdit( this );
  epsfigureED->adjustSize();
  epsfigureED->setMinimumSize(epsfigureED->size());
  epsfigureED->setMaximumHeight(epsfigureED->height());

  QLabel* epsfigureLA = new QLabel( epsfigureED, i18n( "EPS Fi&gure:" ), this );
  epsfigureLA->adjustSize();
  epsfigureLA->setMinimumSize(epsfigureLA->size());
  topHL->addWidget(epsfigureLA);
  epsfigureLA->setAlignment( AlignVCenter | AlignRight | ShowPrefix );

  topHL->addWidget(epsfigureED);
  connect( epsfigureED, SIGNAL( returnPressed() ),
	   this, SLOT( returnPressed() ) );

  epsfigurePB = new QPushButton( i18n( "&Browse..." ), this );
  epsfigurePB->adjustSize();
  epsfigurePB->setMinimumWidth(epsfigurePB->width());
  epsfigurePB->setMaximumHeight(epsfigureED->height());
  topHL->addWidget(epsfigurePB);
  connect( epsfigurePB, SIGNAL( clicked() ), this, SLOT( browseClicked() ) );

  QButtonGroup* widthBG = new QButtonGroup( i18n( "Width" ), this );
  leftGL->addWidget(widthBG, 0, 0);
  QVBoxLayout *widthVL = new QVBoxLayout(widthBG, 15);
  connect( widthBG, SIGNAL( clicked(int) ),
	   this, SLOT( widthGroupClicked(int) ));

  wdefaultRB = new QRadioButton( i18n( "Defa&ult" ), widthBG );
  wdefaultRB->adjustSize();
  wdefaultRB->setMinimumSize(wdefaultRB->size());
  widthVL->addWidget(wdefaultRB);

  wcmRB = new QRadioButton( i18n( "&cm" ), widthBG);
  wcmRB->adjustSize();
  wcmRB->setMinimumSize(wcmRB->size());
  widthVL->addWidget(wcmRB);

  winchesRB = new QRadioButton( i18n( "inc&hes" ), widthBG );
  winchesRB->adjustSize();
  winchesRB->setMinimumSize(winchesRB->size());
  widthVL->addWidget(winchesRB);

  wpercentpageRB = new QRadioButton( i18n( "% of &Page" ), widthBG );
  wpercentpageRB->adjustSize();
  wpercentpageRB->setMinimumSize(wpercentpageRB->size());
  widthVL->addWidget(wpercentpageRB);

  wpercentcolumnRB = new QRadioButton( i18n( "% &of Column" ), widthBG);
  wpercentcolumnRB->adjustSize();
  wpercentcolumnRB->setMinimumSize(wpercentcolumnRB->size());
  widthVL->addWidget(wpercentcolumnRB);

  widthED = new QLineEdit( widthBG );
  widthED->adjustSize();
  widthED->setMinimumWidth(widthED->width());
  widthED->setFixedHeight(widthED->height());
  widthVL->addWidget(widthED);
  widthVL->activate();

  connect( widthED, SIGNAL( returnPressed() ),
	   this, SLOT( returnPressed() ) );

  QButtonGroup* heightBG = new QButtonGroup( i18n( "Height" ), this );
  leftGL->addWidget(heightBG, 0, 1);
  QVBoxLayout *heightVL = new QVBoxLayout(heightBG, 15);
  connect( heightBG, SIGNAL( clicked(int) ),
	   this, SLOT( heightGroupClicked(int) ));

  hdefaultRB = new QRadioButton( i18n( "Defaul&t" ), heightBG);
  hdefaultRB->adjustSize();
  hdefaultRB->setMinimumWidth(hdefaultRB->width());
  heightVL->addWidget(hdefaultRB);

  hcmRB = new QRadioButton( i18n( "c&m" ), heightBG );
  hcmRB->adjustSize();
  hcmRB->setMinimumWidth(hcmRB->width());
  heightVL->addWidget(hcmRB);

  hinchesRB = new QRadioButton( i18n( "inche&s" ), heightBG );
  hinchesRB->adjustSize();
  hinchesRB->setMinimumWidth(hinchesRB->width());
  heightVL->addWidget(hinchesRB);

  hpercentpageRB = new QRadioButton( i18n( "% of Pag&e" ), heightBG );
  hpercentpageRB->adjustSize();
  hpercentpageRB->setMinimumWidth(hpercentpageRB->width());
  heightVL->addWidget(hpercentpageRB);

  heightED = new QLineEdit( heightBG );
  heightED->adjustSize();
  heightED->setMinimumWidth(heightED->width());
  heightED->setFixedHeight(heightED->height());
  heightVL->addWidget(heightED);
  heightVL->activate();
  connect( heightED, SIGNAL( returnPressed() ),
	   this, SLOT( returnPressed() ) );


  QGroupBox* rotationGB = new QGroupBox( i18n( "Rotation" ), this );
  leftGL->addMultiCellWidget(rotationGB, 1, 1, 0, 1);
  QHBoxLayout *rotateHL = new QHBoxLayout( rotationGB , 16);

  angleED = new QLineEdit( rotationGB );
  angleED->adjustSize();
  angleED->setMinimumSize(angleED->size());
  angleED->setFixedHeight(angleED->height());

  QLabel* angleLA = new QLabel( angleED, i18n( "Ang&le" ), rotationGB );
  angleLA->adjustSize();
  angleLA->setMinimumSize(angleLA->size());
  rotateHL->addWidget(angleLA);
  angleLA->setAlignment( AlignVCenter | AlignRight | ShowPrefix );

  rotateHL->addWidget(angleED);
  connect( angleED, SIGNAL( returnPressed() ),
	   this, SLOT( returnPressed() ) );
  rotateHL->activate();

  QButtonGroup* displayBG = new QButtonGroup( i18n( "Display" ), this );
  rightVL->addWidget(displayBG);
  QVBoxLayout *displayVL = new QVBoxLayout(displayBG, 15);
  connect( displayBG, SIGNAL( clicked(int) ),
	   this, SLOT( displayGroupClicked(int) ));

  monochromeRB = new QRadioButton( i18n( "Di&splay as monochrome" ),
				   displayBG );
  monochromeRB->adjustSize();
  monochromeRB->setMinimumSize(monochromeRB->size());
  displayVL->addWidget(monochromeRB);

  grayscaleRB = new QRadioButton( i18n( "D&isplay as grayscale" ), displayBG );
  grayscaleRB->adjustSize();
  grayscaleRB->setMinimumSize(grayscaleRB->size());
  displayVL->addWidget(grayscaleRB);

  colorRB = new QRadioButton( i18n( "&Display in color" ), displayBG );
  colorRB->adjustSize();
  colorRB->setMinimumSize(colorRB->size());
  displayVL->addWidget(colorRB);

  dontdisplayRB = new QRadioButton( i18n( "Do not displa&y this figure" ),
				    displayBG);
  dontdisplayRB->adjustSize();
  dontdisplayRB->setMinimumSize(dontdisplayRB->size());
  displayVL->addWidget(dontdisplayRB);
  displayVL->activate();

  QButtonGroup* optionsBG = new QButtonGroup( i18n( "Options" ), this );
  rightVL->addWidget(optionsBG);
  connect( optionsBG, SIGNAL( clicked(int) ),
	   this, SLOT( optionsGroupClicked(int) ));
  QVBoxLayout *optionsVL = new QVBoxLayout( optionsBG, 15);

  frameCB = new QCheckBox( i18n( "Display &Frame" ), optionsBG );
  frameCB->adjustSize();
  frameCB->setMinimumSize(frameCB->size());
  optionsVL->addWidget(frameCB);

  translationsCB = new QCheckBox( i18n( "Do T&ranslations" ), optionsBG );
  translationsCB->adjustSize();
  translationsCB->setMinimumSize(translationsCB->size());
  optionsVL->addWidget(translationsCB);
  optionsVL->activate();

  QGroupBox* subfigureGB = new QGroupBox( this );
  toplevelVL->addWidget(subfigureGB, 3);
  QHBoxLayout *subfigureHL = new QHBoxLayout(subfigureGB, 15);

  subfigureCB = new QCheckBox( i18n( "Subfigure" ), subfigureGB );
  subfigureCB->adjustSize();
  subfigureCB->setMinimumSize(subfigureCB->size());
  subfigureHL->addWidget(subfigureCB, 1);

  captionED = new QLineEdit( subfigureGB );
  captionED->adjustSize();
  captionED->setMinimumSize(captionED->size());

  QLabel* captionLA = new QLabel( captionED, i18n( "Cap&tion" ), subfigureGB );
  captionLA->adjustSize();
  captionLA->setMinimumSize(captionLA->size());
  subfigureHL->addWidget(captionLA, 1);
  captionLA->setAlignment( AlignVCenter | AlignRight | ShowPrefix);

  subfigureHL->addWidget(captionED, 4);
  subfigureHL->activate();

  toplevelVL->addLayout(buttonHL, 1);

  connect( captionED, SIGNAL( returnPressed() ),
		   this, SLOT( returnPressed() ) );

  okPB = new QPushButton( i18n( "OK" ), this );
  okPB->adjustSize();
  okPB->setFixedHeight(okPB->height());
  okPB->setMinimumWidth(okPB->width());
  buttonHL->addStretch(2);
  buttonHL->addWidget(okPB);
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  applyPB = new QPushButton( i18n( "&Apply" ), this );
  applyPB->adjustSize();
  applyPB->setFixedHeight(applyPB->height());
  applyPB->setMinimumWidth(applyPB->width());
  buttonHL->addWidget(applyPB);
  connect( applyPB, SIGNAL( clicked() ), SLOT( applyClicked() ) );

  cancelPB = new QPushButton( i18n( "Cancel" ), this );
  cancelPB->adjustSize();
  cancelPB->setFixedHeight(cancelPB->height());
  cancelPB->setMinimumWidth(cancelPB->width());
  buttonHL->addWidget(cancelPB);
  connect( cancelPB, SIGNAL( clicked() ), SLOT( cancelClicked() ) );

  previewPB = new QPushButton( i18n( "Full Screen Pre&view" ), this);
  previewPB->adjustSize();
  previewPB->setFixedHeight(previewPB->height());
  previewPB->setMinimumWidth(previewPB->width());
  buttonHL->addWidget(previewPB);

  connect( previewPB, SIGNAL( clicked() ), SLOT( previewClicked() ) );

  toplevelVL->activate();
  resize(300,300);
  setCaption( i18n( "Edit Figure" ) );
}


void EditFigureDialog::okClicked()
{
  applyClicked();
  accept();
}


void EditFigureDialog::cancelClicked()
{
  reject();
}


void EditFigureDialog::applyClicked()
{
  char const* p;

  if(!_view->currentBuffer()->isReadonly())
	{
	  inset->wtype = inset->twtype;
	  inset->htype = inset->thtype;
	  inset->xwid = atof( widthED->text() );
	  inset->xhgh = atof( heightED->text() );
	  inset->angle = atof( angleED->text() );
	  p = epsfigureED->text();
	  if (p && *p) {
		LString buf1 = OnlyPath(inset->owner->getFileName());
		inset->fname = MakeAbsPath(p, buf1);
		inset->changedfname = true;
	  } else {
		if (!inset->fname.empty()) {
		  inset->changedfname = true;
		  inset->fname.clean();
		}
	  }
	  inset->subcaption = captionED->text();
	
	  inset->Regenerate();
	  inset->Recompute();
	  /* now update inset */
	  if (lyxerr.debugging()) {
		printf("Update: [%dx%d]\n", inset->wid, inset->hgh);
	  }
	  UpdateInset( inset );
	} //if not readonly
}


void EditFigureDialog::previewClicked()
{
  int pid;

  signal(SIGCHLD, sigchldhandler);
  pid = fork();

  if (pid == -1) {
        lyxerr.print("Cannot fork process!");
	return;		// error
  }
  if (pid > 0) {
	addpidwait(pid);
	return;		// parent process
  }

  LString buf1 = OnlyPath(inset->owner->getFileName());
  LString buf2 = MakeAbsPath(epsfigureED->text(), buf1);

  lyxerr.print(LString(i18n("Error during rendering ")) +
	       int(execlp(lyxrc->view_pspic_command.c_str(),
			  lyxrc->view_pspic_command.c_str(),
			  buf2.c_str(),
			  NULL)));
  _exit(0);
}


void EditFigureDialog::browseClicked()
{
  LString buf, buf2, bufclip;
  static LString current_figure_path;
  static int once = 0;

  if( lyxerr.debugging() ) {
      printf("Filename: %s\n", inset->owner->getFileName().c_str());
  }
  LString p = epsfigurePB->text();

  buf = MakeAbsPath(inset->owner->getFileName());
  buf2 = OnlyPath(buf);
  if (!p.empty()) {
	buf = MakeAbsPath(p, buf2);
	buf = OnlyPath(buf);
  } else {
      buf = OnlyPath(inset->owner->getFileName().c_str());
  }
	
  // Does user clipart directory exist?
  bufclip = AddName (user_lyxdir, "clipart");	
  FileInfo fileInfo(bufclip);
  if (!(fileInfo.isOK() && fileInfo.isDir()))
      // No - bail out to system clipart directory
      bufclip = AddName (system_lyxdir, "clipart");	

  bool error = false;
  do {
      p = KFileDialog::getOpenFileName( once ? current_figure_path.c_str() : 0,
					QString( "*.eps* *.EPS* *.*eps*.gz *.EPS*.GZ *.ps *.PS *.ps.gz *.PS.GZ *.pz *.PZ|" )
					+ QString( i18n( "All Postscript Files\n" ) )
					+ QString( "*.eps* *.EPS* *.eps*.gz *.EPS*.GZ|" )
					+ QString( i18n( "Encapsulated Postscript Files\n" ) )
					+ QString( "*.ps *.ps.gz *.PS *.PS.GZ|" )
					+ QString( i18n( "Standard Postscript Files\n") )
					+ QString( "*.eps* *.EPS* *.ps *.PS|" )
					+ QString( i18n( "Uncompressed Postscript Files\n") )
					+ QString( "*.eps*.gz *.EPS*.GZ *.ps.gz *.PS.GZ|" )
					+ QString( i18n( "Compressed Postscript Files\n") )
					+ QString( "*|" )
					+ QString( i18n( "All Files") ),
					k_tlw, "Open Postscript Figure" );
	
      if (p.empty()) return;
	
	buf = MakeRelPath(p, buf2);
	current_figure_path = OnlyPath(p);
	once = 1;
	
	if (p.contains("#") || p.contains("~") || p.contains("$")
		|| p.contains("%") || p.contains(" "))
	  {
	    WriteAlert(i18n("Filename can't contain any of these characters:\n"
			    "space, '#', '~', '$' or '%'."));
		error = true;
	  }
  } while (error);

  epsfigureED->setText( buf.c_str() );

  inset->TempRegenerate();
}


void EditFigureDialog::returnPressed()
{
  inset->TempRegenerate();
}


void EditFigureDialog::optionsGroupClicked( int item )
{
    switch( item ) {
    case 0: // frame
	inset->pflags ^= 4;
	break;
    case 1: // translations
	inset->pflags ^= 8;
	break;
    }	
}


void EditFigureDialog::heightGroupClicked( int item )
{
    switch( item ) {
    case InsetFig::DEF:
	inset->thtype = InsetFig::DEF;
	heightED->setEnabled( false );
	break;
    case InsetFig::CM:
	inset->thtype = InsetFig::CM;
	heightED->setEnabled( true );
	heightED->setText( "10" );
	break;
    case InsetFig::IN:
	inset->thtype = InsetFig::IN;
	heightED->setText( "4" );
	heightED->setEnabled( true );
	break;
    case InsetFig::PER_PAGE:
	inset->thtype = InsetFig::PER_PAGE;
	heightED->setEnabled( true );
	heightED->setText( "50" );
	break;
    default:
	lyxerr.debug( "Unknown type!" );
	break;
    }
    inset->TempRegenerate();
}



void EditFigureDialog::widthGroupClicked( int item )
{
    switch( item ) {
    case InsetFig::DEF:
	inset->twtype = InsetFig::DEF;
	widthED->setEnabled( false );
	break;
    case InsetFig::CM:
	inset->twtype = InsetFig::CM;
	widthED->setEnabled( true );
	widthED->setText( "10" );
	break;
    case InsetFig::IN:
	inset->twtype = InsetFig::IN;
	widthED->setEnabled( true );
	widthED->setText( "4" );
	break;
    case InsetFig::PER_PAGE:
	inset->twtype = InsetFig::PER_PAGE;
	widthED->setEnabled( true );
	widthED->setText( "100" );
	break;
    case InsetFig::PER_COL:
	inset->twtype = InsetFig::PER_COL;
	widthED->setEnabled( true );
	widthED->setText( "100" );
	break;
    default:
	lyxerr.debug( "Unknown type!" );
	break;
    }
    inset->TempRegenerate();
}


void EditFigureDialog::displayGroupClicked( int item )
{
  switch( item )
	{
	case 0: // monochrome
	  inset->pflags = (inset->pflags & ~3) | 1;	/* wysiwyg1 */
	  break;
	case 1: // grayscale
	  inset->pflags = (inset->pflags & ~3) | 2;	/* wysiwyg2 */
	  break;
	case 2: // color
	  inset->pflags = (inset->pflags & ~3) | 3;	/* wysiwyg3 */
	  break;
	case 3: // don't display
	  inset->pflags = inset->pflags & ~3;		/* wysiwyg0 */
	  break;
	}
}


void EditFigureDialog::subfigureToggled( bool )
{
  inset->psubfigure = !inset->psubfigure;	/* This is a subfigure */
}


void EditFigureDialog::enable()
{
  epsfigureED->setEnabled( true );
  epsfigurePB->setEnabled( true );
  wdefaultRB->setEnabled( true );
  wcmRB->setEnabled( true );
  winchesRB->setEnabled( true );
  wpercentpageRB->setEnabled( true );
  wpercentcolumnRB->setEnabled( true );
  widthED->setEnabled( true );
  hdefaultRB->setEnabled( true );
  hcmRB->setEnabled( true );
  hinchesRB->setEnabled( true );
  hpercentpageRB->setEnabled( true );
  heightED->setEnabled( true );
  monochromeRB->setEnabled( true );
  grayscaleRB->setEnabled( true );
  colorRB->setEnabled( true );
  dontdisplayRB->setEnabled( true );
  frameCB->setEnabled( true );
  translationsCB->setEnabled( true );
  angleED->setEnabled( true );
  subfigureCB->setEnabled( true );
  captionED->setEnabled( true );
  okPB->setEnabled( true );
  applyPB->setEnabled( true );
  cancelPB->setEnabled( true );
  previewPB->setEnabled( true );
}


void EditFigureDialog::disable()
{
  epsfigureED->setEnabled( false );
  epsfigurePB->setEnabled( false );
  wdefaultRB->setEnabled( false );
  wcmRB->setEnabled( false );
  winchesRB->setEnabled( false );
  wpercentpageRB->setEnabled( false );
  wpercentcolumnRB->setEnabled( false );
  widthED->setEnabled( false );
  hdefaultRB->setEnabled( false );
  hcmRB->setEnabled( false );
  hinchesRB->setEnabled( false );
  hpercentpageRB->setEnabled( false );
  heightED->setEnabled( false );
  monochromeRB->setEnabled( false );
  grayscaleRB->setEnabled( false );
  colorRB->setEnabled( false );
  dontdisplayRB->setEnabled( false );
  frameCB->setEnabled( false );
  translationsCB->setEnabled( false );
  angleED->setEnabled( false );
  subfigureCB->setEnabled( false );
  captionED->setEnabled( false );
  okPB->setEnabled( false );
  applyPB->setEnabled( false );
  cancelPB->setEnabled( false );
  previewPB->setEnabled( false );
}

/*
 * $Log: EditFigureDialog.C,v $
 * Revision 1.13  1999/04/23 13:20:57  kuepper
 * Make the EditFigure dialog have some usefull default widhts/heights.
 *
 * Revision 1.12  1999/04/21 14:01:26  kuepper
 * Enhanced file filters when importing figures.
 *
 * Revision 1.11  1999/01/06 13:32:14  kulow
 * aha! That explains it! I should have read the kfile docu first ;-)
 *
 * Revision 1.10  1999/01/05 10:57:26  kulow
 * I love commented filters for KFile - others may as well
 *
 * Revision 1.9  1998/12/01 09:08:42  rocher
 * "*.eps" and "*ps" extension file.
 *
 * Revision 1.8  1998/08/09 15:18:31  ettrich
 * Matthias: uses kfiledialog now
 *
 */



// Local Variables:
// mode: C++
// c-file-style: "Stroustrup"
// End:
