/*
 * $Id: KeyboardOptionsDialog.C,v 1.7 1999/01/05 11:16:36 kulow Exp $
 */

#include <qslider.h>

#include "KeyboardOptionsDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qbttngrp.h>
#include <qchkbox.h>
#include <qcombo.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qradiobt.h>

#include "LyXView.h"
#include "intl.h"
#include "trans_mgr.h"

KeyboardOptionsDialog::KeyboardOptionsDialog( LyXView* view, QWidget * parent=0, const char * name=0, WFlags f=0 )
    : QDialog( parent, name, true, f ),
      _view( view )
{
  QGroupBox* languageGB = new QGroupBox( i18n( "Language" ),
										 this );
  languageGB->setGeometry( 10, 10, 270, 190 );

  QLabel* primaryLA = new QLabel( i18n( "Primary" ), this );
  primaryLA->setGeometry( 15, 30, 75, 30 );
  primaryLA->setAlignment( AlignVCenter | AlignRight );

  primaryCB = new QComboBox( false, this );
  primaryCB->setGeometry( 100, 30, 170, 30 );
  connect( primaryCB, SIGNAL( activated( int ) ),
		   this, SLOT( primaryLanguageSelected( int ) ) );

  QLabel* primaryotherLA = new QLabel( i18n( "Other" ), this );
  primaryotherLA->setGeometry( 20, 70, 70, 30 );
  primaryotherLA->setAlignment( AlignVCenter | AlignRight );

  primaryotherED = new QLineEdit( this );
  primaryotherED->setGeometry( 100, 70, 170, 30 );

  QLabel* secondaryLA = new QLabel( i18n( "Secondary" ), this );
  secondaryLA->setGeometry( 15, 110, 75, 30 );
  secondaryLA->setAlignment( AlignVCenter | AlignRight );

  secondaryCB = new QComboBox( false, this );
  secondaryCB->setGeometry( 100, 110, 170, 30 );
  connect( secondaryCB, SIGNAL( activated( int ) ),
		   this, SLOT( secondaryLanguageSelected( int ) ) );

  QLabel* secondaryotherLA = new QLabel( i18n( "Other" ), this );
  secondaryotherLA->setGeometry( 20, 150, 70, 30 );
  secondaryotherLA->setAlignment( AlignVCenter | AlignRight );

  secondaryotherED = new QLineEdit( this );
  secondaryotherED->setGeometry( 100, 150, 170, 30 );


  errorLA = new QLabel( i18n( "Error:\n\nKeymap\nnot found" ),
						this );
  errorLA->setGeometry( 290, 40, 110, 140 );
  QPalette palette = errorLA->palette();
  QColorGroup ncg = palette.normal();
  palette.setNormal( QColorGroup( red, ncg.background(), ncg.light(),
								  ncg.dark(), ncg.mid(),
								  ncg.text(), ncg.base() ) );
  errorLA->setPalette( palette );
  errorLA->hide();


  QButtonGroup* mappingBG = new QButtonGroup( i18n( "Mapping" ),
											  this );
  mappingBG->setGeometry( 10, 210, 170, 120 );

  nokeymappingRB = new QRadioButton( i18n( "&No key mapping" ),
									 this );
  nokeymappingRB->setGeometry( 20, 230, 150, 30 );
  connect( nokeymappingRB, SIGNAL( toggled( bool ) ),
		   this, SLOT( keymapOffToggled( bool ) ) );
  mappingBG->insert( nokeymappingRB );

  primarykeymapRB = new QRadioButton( i18n( "P&rimary key map" ),
									  this );
  primarykeymapRB->setGeometry( 20, 260, 150, 30 );
  connect( primarykeymapRB, SIGNAL( toggled( bool ) ),
		   this, SLOT( primaryKeymapToggled( bool ) ) );
  mappingBG->insert( primarykeymapRB );

  secondarykeymapRB = new QRadioButton( i18n( "S&econdary key map" ),
										this );
  secondarykeymapRB->setGeometry( 20, 290, 150, 30 );
  connect( secondarykeymapRB, SIGNAL( toggled( bool ) ),
		   this, SLOT( secondaryKeymapToggled( bool ) ) );
  mappingBG->insert( secondarykeymapRB );


  QGroupBox* charactersetGB = new QGroupBox( i18n( "Character Set" ),
								  this );
  charactersetGB->setGeometry( 190, 210, 210, 120 );

  charactersetED = new QLineEdit( this );
  charactersetED->setGeometry( 200, 230, 180, 30 );

  QPushButton* charactersetPB = new QPushButton( i18n( "Set" ),
												 this );
  charactersetPB->setGeometry( 240, 280, 100, 30 );
  connect( charactersetPB, SIGNAL( clicked() ),
		   this, SLOT( setCharsetClicked() ) );

  QCheckBox* swapyzCH = new QCheckBox( i18n( "Swap &Y and Z" ),
									   this );
  swapyzCH->setGeometry( 160, 340, 110, 30 );

  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->setGeometry( 90, 380, 100, 30 );
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ),
										   this );
  cancelPB->setGeometry( 220, 380, 100, 30 );
  connect( cancelPB, SIGNAL( clicked() ), SLOT( cancelClicked() ) );

  setCaption( i18n( "Keyboard Options" ) );
}


void KeyboardOptionsDialog::okClicked()
{
  accept();
}


void KeyboardOptionsDialog::cancelClicked()
{
  reject();
}


void KeyboardOptionsDialog::setCharsetClicked()
{
  QString p = charactersetED->text();
  if( intl->trans->setCharset( p.data() ) )
	showError();
  else
	hideError();
}


void KeyboardOptionsDialog::keymapOffToggled( bool state )
{
  if( state == true )
	intl->KeyMapOn( false );
}


void KeyboardOptionsDialog::primaryKeymapToggled( bool state )
{
  if( state == true )
	intl->KeyMapPrim();
}


void KeyboardOptionsDialog::secondaryKeymapToggled( bool state )
{
  if( state == true )
	intl->KeyMapSec();
}


void KeyboardOptionsDialog::primaryLanguageSelected( int )
{
  intl->KeyMapPrim();
}


void KeyboardOptionsDialog::secondaryLanguageSelected( int )
{
  intl->KeyMapSec();
}


void KeyboardOptionsDialog::setKeymapButtons( bool no, bool prim, bool sec )
{
  disconnect( nokeymappingRB, SIGNAL( toggled( bool ) ),
			  this, SLOT( keymapOffToggled( bool ) ) );
  disconnect( primarykeymapRB, SIGNAL( toggled( bool ) ),
			  this, SLOT( primaryKeymapToggled( bool ) ) );
  disconnect( secondarykeymapRB, SIGNAL( toggled( bool ) ),
			  this, SLOT( secondaryKeymapToggled( bool ) ) );
  nokeymappingRB->setChecked( no );
  primarykeymapRB->setChecked( prim );
  secondarykeymapRB->setChecked( sec );
  connect( nokeymappingRB, SIGNAL( toggled( bool ) ),
		   this, SLOT( keymapOffToggled( bool ) ) );
  connect( primarykeymapRB, SIGNAL( toggled( bool ) ),
		   this, SLOT( primaryKeymapToggled( bool ) ) );
  connect( secondarykeymapRB, SIGNAL( toggled( bool ) ),
		   this, SLOT( secondaryKeymapToggled( bool ) ) );
}


void KeyboardOptionsDialog::setNoKeymapButton()
{
  setKeymapButtons( true, false, false );
}


void KeyboardOptionsDialog::hideError()
{
  errorLA->hide();
}


void KeyboardOptionsDialog::showError()
{
  errorLA->show();
}


QString KeyboardOptionsDialog::getPrimaryLanguage() const
{
  return primaryCB->currentText();
}


QString KeyboardOptionsDialog::getPrimaryOther() const
{
  return primaryotherED->text();
}


int KeyboardOptionsDialog::getPrimaryCode() const
{
  return primaryCB->currentItem();
}


QString KeyboardOptionsDialog::getSecondaryLanguage() const
{
  return secondaryCB->currentText();
}


QString KeyboardOptionsDialog::getSecondaryOther() const
{
  return secondaryotherED->text();
}


int KeyboardOptionsDialog::getSecondaryCode() const
{
  return secondaryCB->currentItem();
}


void KeyboardOptionsDialog::setCharset( const char* charset )
{
  charactersetED->setText( charset );
}


void KeyboardOptionsDialog::insertPrimaryLanguage( const char* language )
{
  primaryCB->insertItem( language );
}


void KeyboardOptionsDialog::insertSecondaryLanguage( const char* language )
{
  secondaryCB->insertItem( language );
}


bool KeyboardOptionsDialog::isInPrimary( const char* language ) const
{
  for( int i = 0; i < primaryCB->count(); i++ )
	if( !strcmp( primaryCB->text( i ), language ) )
	  return true;

  return false;
}


bool KeyboardOptionsDialog::isInSecondary( const char* language ) const
{
  for( int i = 0; i < secondaryCB->count(); i++ )
	if( !strcmp( secondaryCB->text( i ), language ) )
	  return true;

  return false;
}


void KeyboardOptionsDialog::setCurrentPrimary( int pos )
{
  primaryCB->setCurrentItem( pos );
}


void KeyboardOptionsDialog::setCurrentSecondary( int pos )
{
  secondaryCB->setCurrentItem( pos );
}


void KeyboardOptionsDialog::setPrimaryOther( const char* language )
{
  primaryotherED->setText( language );
}


void KeyboardOptionsDialog::setSecondaryOther( const char* language )
{
  secondaryotherED->setText( language );
}



/*
 * $Log: KeyboardOptionsDialog.C,v $
 * Revision 1.7  1999/01/05 11:16:36  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.6  1998/09/04 16:07:42  ettrich
 * Matthias: bugfixes
 *
 * Revision 1.5  1998/08/11 14:34:06  kuepper
 * KDE-ified the dialog to make the buttons the same size and enhance the
 * overall layout.
 *
 * Revision 1.4  1998/06/09 13:08:14  schreter
 *
 *
 * Added support for autodetection of charset, document encoding and
 * document language. tex_babel was changed to contain locale codes for
 * languages for autodetection of language from locale. Somebody please
 * revise it, so that it contains proper locale codes for all languages.
 *
 * Revision 1.3  1998/05/17 15:57:59  schreter
 *
 *
 * Changed label widths to fit in Slovak translations (mainly).
 * Also added character set autodetection (from /opt/kderc, General Font,
 * Charset). It only accepts iso8859-1,2,7, since only these do have
 * .cdef files for them. Use DEFCHARSET (defined in klyx.h) for defaults
 * in config reads, etc. I've changed string "iso8859-1" to DEFCHARSET
 * where appropriate.
 * TODO: fix autodetection, use some locale functions instead of kderc.
 *
 * Revision 1.2  1998/03/04 21:49:23  kalle
 * More Qt-ified
 *
 * Revision 1.1  1998/02/08 10:36:23  kalle
 * - added KeyboardOptionsDialog
 * - integrated KeyboardOptionsDialog into Intl class
 * - removed old combo box (finally!)
 *
 */
