/*
 * $Id: PaperFormatDialog.C,v 1.6 1998/06/08 21:40:08 kalle Exp $
 */

#include "PaperFormatDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qbttngrp.h>
#include <qchkbox.h>
#include <qcombo.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qradiobt.h>

#include "LyXView.h"
#include "BufferView.h"
#include "minibuffer.h"
#include <qlayout.h>


PaperFormatDialog::PaperFormatDialog( LyXView* view, QWidget * parent=0, 
				      const char * name=0, 
				      WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  QVBoxLayout *toplevelVL = new QVBoxLayout(this, 10);
  QHBoxLayout *topHL = new QHBoxLayout(6);
  QGridLayout *bodyGL = new QGridLayout(2, 2, 5);
  QHBoxLayout *buttonsHL = new QHBoxLayout(10);

  toplevelVL->addLayout(topHL);

  papersizeCO = new QComboBox( false, this );
  connect( papersizeCO, SIGNAL( activated( int ) ),
	   this, SLOT( papersizeSelected( int ) ) );

  papersizeCO->insertItem( "Default" );
  papersizeCO->insertItem( "Custom" );
  papersizeCO->insertItem( "US letter" );
  papersizeCO->insertItem( "US legal" );
  papersizeCO->insertItem( "US executive" );
  papersizeCO->insertItem( "A3" );
  papersizeCO->insertItem( "A4" );
  papersizeCO->insertItem( "A5" );
  papersizeCO->insertItem( "B3" );
  papersizeCO->insertItem( "B4" );
  papersizeCO->insertItem( "B5" );
  papersizeCO->adjustSize();
  papersizeCO->setMinimumSize(papersizeCO->size());
  papersizeCO->setMaximumHeight(papersizeCO->height());

  QLabel* papersizeLA = new QLabel( papersizeCO, i18n( "&Papersize:" ), this );
  papersizeLA->adjustSize();
  papersizeLA->setMinimumSize(papersizeLA->size());
  topHL->addStretch(3);
  topHL->addWidget(papersizeLA);
  topHL->addWidget(papersizeCO);
  topHL->addStretch(3);
  papersizeLA->setAlignment( AlignVCenter | AlignRight | ShowPrefix );
  
  specialCO = new QComboBox( false, this );
  connect( specialCO, SIGNAL( activated( int ) ),
		   this, SLOT( specialSelected( int ) ) );

  specialCO->insertItem( "None" );
  specialCO->insertItem( "A4 small Margins (only portrait)" );
  specialCO->insertItem( "A4 very small Margins (only portrait)" );
  specialCO->insertItem( "A4 very wide margins (only portrait)" );
  specialCO->adjustSize();
  specialCO->setMinimumSize(specialCO->size());
  specialCO->setMaximumHeight(specialCO->height());

  QLabel* specialLA = new QLabel( specialCO, i18n( "&Special:" ), this );
  specialLA->adjustSize();
  specialLA->setMinimumSize(specialCO->size());
  specialLA->setMaximumWidth(specialCO->width());
  topHL->addWidget(specialLA);
  topHL->addWidget(specialCO);
  topHL->addStretch(3);
  specialLA->setAlignment( AlignVCenter | AlignRight | ShowPrefix );
  
  geometrypackageCB = new QCheckBox( i18n( "&Use Geometry Package" ), this );
  geometrypackageCB->adjustSize();
  geometrypackageCB->setFixedSize(geometrypackageCB->size());
  toplevelVL->addWidget(geometrypackageCB, 0, AlignCenter);

  toplevelVL->addLayout(bodyGL);
  QButtonGroup* orientationBG = new QButtonGroup( i18n( "Orientation" ), this);
  bodyGL->addWidget(orientationBG, 0, 0);
  
  QVBoxLayout *orientationVL = new QVBoxLayout(orientationBG, 15);
  portraitRB = new QRadioButton( i18n( "P&ortrait" ), orientationBG );
  portraitRB->adjustSize();
  portraitRB->setMinimumSize(portraitRB->size());
  orientationVL->addWidget(portraitRB);
  portraitRB->setChecked( true );

  landscapeRB = new QRadioButton( i18n( "&Landscape" ), orientationBG );
  landscapeRB->adjustSize();
  landscapeRB->setMinimumSize(landscapeRB->size());

  orientationVL->addWidget(landscapeRB);
  orientationVL->activate();

  QGroupBox* marginsGB = new QGroupBox( i18n( "Margins" ), this );
  bodyGL->addWidget(marginsGB, 1, 0);

  QGridLayout *marginVL = new QGridLayout(marginsGB, 4, 2, 15);

  topED = new QLineEdit( marginsGB );
  topED->adjustSize();
  topED->setMinimumSize(topED->size());
  topED->setMaximumHeight(topED->height());
  
  QLabel* topLA = new QLabel( topED, i18n( "&Top:" ), marginsGB );
  marginVL->addWidget(topLA, 0, 0);
  topLA->setAlignment( AlignVCenter | AlignRight | ShowPrefix );
  marginVL->addWidget(topED, 0, 1);
  connect( topED, SIGNAL( returnPressed() ), this, SLOT( topReturn() ) );

  bottomED = new QLineEdit( marginsGB );
  bottomED->adjustSize();
  bottomED->setMinimumSize(bottomED->size());
  bottomED->setMaximumHeight(bottomED->height());

  QLabel* bottomLA = new QLabel(bottomED, i18n( "&Bottom:" ), marginsGB );
  bottomLA->adjustSize();
  bottomLA->setMinimumSize(bottomLA->size());
  marginVL->addWidget(bottomLA, 1, 0);
  bottomLA->setAlignment( AlignVCenter | AlignRight | ShowPrefix );

  marginVL->addWidget(bottomED, 1, 1);
  connect( bottomED, SIGNAL( returnPressed() ), this, SLOT( bottomReturn() ) );

  leftED = new QLineEdit( marginsGB );
  leftED->adjustSize();
  leftED->setMinimumSize(leftED->size());
  leftED->setMaximumHeight(leftED->height());

  QLabel* leftLA = new QLabel( leftED, i18n( "&Left:" ), marginsGB );
  marginVL->addWidget(leftLA, 2, 0);
  leftLA->setAlignment( AlignVCenter | AlignRight | ShowPrefix );
  
  marginVL->addWidget(leftED, 2, 1);
  connect( leftED, SIGNAL( returnPressed() ), this, SLOT( leftReturn() ) );

  rightED = new QLineEdit( marginsGB );
  rightED->adjustSize();
  rightED->setMinimumSize(rightED->size());
  rightED->setMaximumHeight(rightED->height());
  QLabel* rightLA = new QLabel( rightED, i18n( "&Right:" ), marginsGB );
  rightLA->adjustSize();
  rightLA->setMinimumSize(rightLA->size());
  marginVL->addWidget(rightLA, 3, 0);
  rightLA->setAlignment( AlignVCenter | AlignRight | ShowPrefix );
  marginVL->addWidget(rightED, 3, 1);
  connect( rightED, SIGNAL( returnPressed() ), this, SLOT( rightReturn() ) );
  marginVL->activate();

  QGroupBox* customGB = new QGroupBox( i18n( "Custom Papersize" ), this );
  bodyGL->addWidget(customGB, 0, 1);
  QGridLayout *customGL = new QGridLayout(customGB, 2, 2, 15);


  widthED = new QLineEdit( customGB );
  widthED->adjustSize();
  widthED->setMinimumSize(widthED->size());
  widthED->setMaximumHeight(widthED->height());
    
  QLabel* widthLA = new QLabel( widthED, i18n( "&Width:" ), customGB );
  widthLA->adjustSize();
  widthLA->setMinimumSize(widthLA->size());
  
  customGL->addWidget(widthLA, 0, 0);
  widthLA->setAlignment( AlignVCenter | AlignRight | ShowPrefix );
  customGL->addWidget(widthED, 0, 1);
  connect( widthED, SIGNAL( returnPressed() ),
		   this, SLOT( widthReturn() ) );
  
  heightED = new QLineEdit( customGB );
  heightED->adjustSize();
  heightED->setMinimumSize(heightED->size());
  heightED->setMaximumHeight(heightED->height());

  QLabel* heightLA = new QLabel( heightED, i18n( "&Height:" ), customGB );
  heightLA->adjustSize();
  heightLA->setMinimumSize(heightLA->size());
  customGL->addWidget(heightLA, 1, 0);
  heightLA->setAlignment( AlignVCenter | AlignRight | ShowPrefix );

  customGL->addWidget(heightED, 1, 1);
  connect( heightED, SIGNAL( returnPressed() ),
	   this, SLOT( heightReturn() ) );
  customGL->activate();

  QGroupBox* footheadGB = new QGroupBox( i18n( "Foot/Head Margins" ), this );
  bodyGL->addWidget(footheadGB, 1, 1);
  
  QGridLayout *footheadGL = new QGridLayout(footheadGB, 7, 2, 6);

  headheightED = new QLineEdit( footheadGB );
  headheightED->adjustSize();
  headheightED->setMinimumSize(headheightED->size());
  headheightED->setMaximumHeight(headheightED->height());
  QLabel* headheightLA = new QLabel( headheightED, i18n( "&Headheight:" ),
									 footheadGB );
  headheightLA->adjustSize();
  headheightLA->setMinimumSize(headheightLA->size());
  footheadGL->addWidget(headheightLA, 1, 0);
  headheightLA->setAlignment( AlignVCenter | AlignRight | ShowPrefix );

  footheadGL->addWidget(headheightED, 1, 1);
  connect( headheightED, SIGNAL( returnPressed() ),
		   this, SLOT( headheightReturn() ) );
  
  headsepED = new QLineEdit( footheadGB );
  headsepED->adjustSize();
  headsepED->setMinimumSize(headsepED->size());
  headsepED->setMaximumHeight(headsepED->height());
  QLabel* headsepLA = new QLabel( headsepED, i18n( "&Headsep:" ), footheadGB );
  footheadGL->addWidget(headsepLA, 3, 0);
  headsepLA->setAlignment( AlignVCenter | AlignRight | ShowPrefix );
  footheadGL->addWidget(headsepED, 3, 1);
  connect( headsepED, SIGNAL( returnPressed() ),
		   this, SLOT( headsepReturn() ) );
  
  footskipED = new QLineEdit( footheadGB );
  footskipED->adjustSize();
  footskipED->setMinimumSize(footskipED->size());
  footskipED->setMaximumHeight(footskipED->height());
  QLabel* footskipLA = new QLabel( footskipED, i18n( "&Footskip:" ), 
								   footheadGB );
  footskipLA->adjustSize();
  footskipLA->setMinimumSize(footskipLA->size());
  footheadGL->addWidget(footskipLA, 5, 0);
  footskipLA->setAlignment( AlignVCenter | AlignRight | ShowPrefix );

  footheadGL->addWidget(footskipED, 5, 1);
  connect( footskipED, SIGNAL( returnPressed() ),
		   this, SLOT( footskipReturn() ) );
  for (int i = 0; i < 7; i++)
    footheadGL->setRowStretch(i, 1);

  footheadGL->activate();
  warningLA = new QLabel( i18n( "Warning: Invalid Length (valid example: 10mm)" ), this );
  warningLA->adjustSize();
  warningLA->setMinimumSize(warningLA->size());
  // to make alignment working
  warningLA->setMaximumWidth(warningLA->width() * 2);
  toplevelVL->addWidget(warningLA);
  warningLA->hide();
  toplevelVL->addLayout(buttonsHL);

  okPB = new QPushButton( i18n( "OK" ), this );
  okPB->adjustSize();
  okPB->setMinimumSize(okPB->size());
  okPB->setMaximumHeight(okPB->height());
  buttonsHL->addStretch(3);
  buttonsHL->addWidget(okPB);
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ), this );
  cancelPB->adjustSize();
  cancelPB->setMinimumSize(cancelPB->size());
  cancelPB->setMaximumHeight(cancelPB->height());
  buttonsHL->addStretch(1);
  buttonsHL->addWidget(cancelPB);
  buttonsHL->addStretch(3);
  connect( cancelPB, SIGNAL( clicked() ), SLOT( cancelClicked() ) );
  
  toplevelVL->activate();
  setCaption( i18n( "Configure PaperFormat" ) );
}


void PaperFormatDialog::okClicked()
{
  if( !_view->currentView()->available() ) 
	return;

  BufferParams *params = &_view->currentView()->currentBuffer()->params;

  params->papersize2 = papersizeCO->currentItem();
  params->paperpackage = specialCO->currentItem();
  params->use_geometry = geometrypackageCB->isChecked();
  if( landscapeRB->isChecked() )
	params->orientation = ORIENTATION_LANDSCAPE;
  else
	params->orientation = ORIENTATION_PORTRAIT;
  params->paperwidth = widthED->text();
  params->paperheight = heightED->text();
  params->leftmargin = leftED->text();
  params->topmargin = topED->text();
  params->rightmargin = rightED->text();
  params->bottommargin = bottomED->text();
  params->headheight = headheightED->text();
  params->headsep = headsepED->text();
  params->footskip = footskipED->text();
  _view->currentView()->currentBuffer()->setPaperStuff();
  _view->getMiniBuffer()->Set(i18n("Paper layout set"));
  _view->currentView()->currentBuffer()->markDirty();
	
  accept();
}


void PaperFormatDialog::cancelClicked()
{
  reject();
}


void PaperFormatDialog::activate()
{
  okPB->setEnabled( true );
}


void PaperFormatDialog::deactivate()
{
  okPB->setEnabled( false );
}


void PaperFormatDialog::enable()
{
  activate();
  geometrypackageCB->setEnabled( true );
  papersizeCO->setEnabled( true );
  specialCO->setEnabled( true );
  portraitRB->setEnabled( true );
  landscapeRB->setEnabled( true );
  topED->setEnabled( true );
  bottomED->setEnabled( true );
  leftED->setEnabled( true );
  rightED->setEnabled( true );
  widthED->setEnabled( true );
  heightED->setEnabled( true );
  headheightED->setEnabled( true );
  headsepED->setEnabled( true );
  footskipED->setEnabled( true );
}


void PaperFormatDialog::disable()
{
  deactivate();
  geometrypackageCB->setEnabled( false );
  papersizeCO->setEnabled( false );
  specialCO->setEnabled( false );
  portraitRB->setEnabled( false );
  landscapeRB->setEnabled( false );
  topED->setEnabled( false );
  bottomED->setEnabled( false );
  leftED->setEnabled( false );
  rightED->setEnabled( false );
  widthED->setEnabled( false );
  heightED->setEnabled( false );
  headheightED->setEnabled( false );
  headsepED->setEnabled( false );
  footskipED->setEnabled( false );
}


void PaperFormatDialog::checkMarginValues()
{
  int  allEmpty;
    
  warningLA->hide();

  allEmpty = ( !strlen( topED->text() ) &&
			   !strlen( bottomED->text() ) &&
			   !strlen( leftED->text() ) &&
			   !strlen( rightED->text() ) &&
			   !strlen( headheightED->text() ) &&
			   !strlen( headsepED->text() ) &&
			   !strlen( footskipED->text() ) &&
			   !strlen( widthED->text() ) &&
			   !strlen( heightED->text() ) );

  if( !allEmpty )
	geometrypackageCB->setChecked( true );
}


void PaperFormatDialog::papersizeSelected( int item )
{
  LString str;

  checkMarginValues();
  
  if( item == VM_PAPER_DEFAULT ) {
	geometrypackageCB->setChecked( false );
	checkMarginValues();
  } else {
	if( ( item != VM_PAPER_USLETTER ) && ( item != VM_PAPER_USLEGAL ) &&
		( item != VM_PAPER_USEXECUTIVE ) && ( item != VM_PAPER_A4 ) &&
		( item != VM_PAPER_A5 ) && ( item != VM_PAPER_B5 ) )
	  geometrypackageCB->setChecked( true );
	specialCO->setCurrentItem( PACKAGE_NONE );
  }
}


void PaperFormatDialog::specialSelected( int item )
{
  if( item != PACKAGE_NONE ) {
	papersizeCO->setCurrentItem( VM_PAPER_DEFAULT );
	geometrypackageCB->setChecked( false );
  }
}


void PaperFormatDialog::widthReturn()
{
  if( strlen( widthED->text() ) && !isValidLength( widthED->text() ) ) {
    warningLA->setText( i18n("Warning: Invalid Length (valid example: 10mm)") );
    warningLA->show();
    deactivate();
  } else if( strlen( widthED->text() ) )
    geometrypackageCB->setChecked( true );
}


void PaperFormatDialog::heightReturn()
{
  if( strlen( heightED->text() ) && !isValidLength( heightED->text() ) ) {
	warningLA->setText( i18n("Warning: Invalid Length (valid example: 10mm)") );
	warningLA->show();
	deactivate();
  } else if( strlen( heightED->text() ) )
	geometrypackageCB->setChecked( true );
}


void PaperFormatDialog::leftReturn()
{
  if( strlen( leftED->text() ) && !isValidLength( leftED->text() ) ) {
	warningLA->setText( i18n("Warning: Invalid Length (valid example: 10mm)") );
	warningLA->show();
	deactivate();
  } else if( strlen( leftED->text() ) )
	geometrypackageCB->setChecked( true );
}


void PaperFormatDialog::rightReturn()
{
  if( strlen( rightED->text() ) && !isValidLength( rightED->text() ) ) {
	warningLA->setText( i18n("Warning: Invalid Length (valid example: 10mm)") );
	warningLA->show();
	deactivate();
  } else if( strlen( rightED->text() ) )
	geometrypackageCB->setChecked( true );
}


void PaperFormatDialog::topReturn()
{
  if( strlen( topED->text() ) && !isValidLength( topED->text() ) ) {
	warningLA->setText( i18n("Warning: Invalid Length (valid example: 10mm)") );
	warningLA->show();
	deactivate();
  } else if( strlen( topED->text() ) )
	geometrypackageCB->setChecked( true );
}


void PaperFormatDialog::bottomReturn()
{
  if( strlen( bottomED->text() ) && !isValidLength( bottomED->text() ) ) {
	warningLA->setText( i18n("Warning: Invalid Length (valid example: 10mm)") );
	warningLA->show();
	deactivate();
  } else if( strlen( bottomED->text() ) )
	geometrypackageCB->setChecked( true );
}


void PaperFormatDialog::headheightReturn()
{
  if( strlen( headheightED->text() ) && !isValidLength( headheightED->text() ) ) {
	warningLA->setText( i18n("Warning: Invalid Length (valid example: 10mm)") );
	warningLA->show();
	deactivate();
  } else if( strlen( headheightED->text() ) )
	geometrypackageCB->setChecked( true );
}


void PaperFormatDialog::headsepReturn()
{
  if( strlen( headsepED->text() ) && !isValidLength( headsepED->text() ) ) {
	warningLA->setText( i18n("Warning: Invalid Length (valid example: 10mm)") );
	warningLA->show();
	deactivate();
  } else if( strlen( headsepED->text() ) )
	geometrypackageCB->setChecked( true );
}


void PaperFormatDialog::footskipReturn()
{
  if( strlen( footskipED->text() ) && !isValidLength( footskipED->text() ) ) {
	warningLA->setText( i18n("Warning: Invalid Length (valid example: 10mm)") );
	warningLA->show();
	deactivate();
  } else if( strlen( footskipED->text() ) )
	geometrypackageCB->setChecked( true );
}




/*
 * $Log: PaperFormatDialog.C,v $
 * Revision 1.6  1998/06/08 21:40:08  kalle
 * Fixing bugs by the pound:
 * - corrected brelsubseteq.xbm
 * - math delimiter dialog shows delimiters correctly when called the second time
 * - corrected signal connection in paper format dialog
 * - added switch --no-splash for avoiding the splash screen
 *
 * Revision 1.5  1998/03/17 15:56:32  ettrich
 * Matthias: fixed half a million of bugs
 *
 * Revision 1.4  1998/03/04 21:49:32  kalle
 * More Qt-ified
 *
 * Revision 1.3  1998/03/04 20:08:11  kulow
 * new GM dialog
 *
 * Revision 1.2  1998/03/01 22:56:52  kulow
 * some cosmetic changes on the strings
 *
 * Revision 1.1  1998/02/09 22:26:23  kalle
 *  - added PaperFormatDialog
 * - added QuotesDialog
 *
 */
