/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *
 *======================================================*/

#include <config.h>

#include <kapp.h>
#include <klocale.h>

#include "definitions.h"
#include "inseterror.h"
#include "lyxdraw.h"
#include "InsertErrorDialog.h"
#include "LyXView.h"

// 	$Id: inseterror.C,v 1.6 1999/01/05 11:17:08 kulow Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: inseterror.C,v 1.6 1999/01/05 11:17:08 kulow Exp $";
#endif /* lint */

extern BufferView* current_view;

/* Error, used for the LaTeX-Error Messages */

InsetError::InsetError()
{
}

InsetError::InsetError(LString const & string)
  : contents(string)
{
}


InsetError::~InsetError()
{
}


int InsetError::Ascent(LyXFont const &font) const
{
  LyXFont efont;
  efont.setSize(font.size()).decSize();
  return efont.maxAscent()+1;
}


int InsetError::Descent(LyXFont const &font) const
{
  LyXFont efont;
  efont.setSize(font.size()).decSize();
  return efont.maxDescent()+1;
}


int InsetError::Width(LyXFont const &font) const
{
  LyXFont efont;
  efont.setSize(font.size()).decSize();
  return 6 + efont.textWidth(i18n("Error"), strlen(klocale->translate("Error")));
}


void InsetError::Draw(LyXFont font, LyXScreen &scr,
					  int baseline, float &x)
{
  LyXFont efont;
  efont.setSize(font.size()).decSize();
  efont.setLatex(LyXFont::ON);
  
  // Draw as "Error" in a framed box
  x += 1;
  //scr.drawFilledRectangle(int(x), baseline - Ascent(font)+1,
  //			Width(font)-2,Ascent(font)+ Descent(font)-2,
  //			FL_GRAY80);
  scr.fillRectangle(gc_lighted,
					int(x), baseline - Ascent(font)+1,
					Width(font)-2,Ascent(font)+ Descent(font)-2);
  //scr.drawRectangle(int(x), baseline-Ascent(font)+1,
  //		  Width(font)-2, Ascent(font)+Descent(font)-2,
  //		  FL_RED);
  scr.drawRectangle(gc_foot,
					int(x), baseline-Ascent(font)+1,
					Width(font)-2, Ascent(font)+Descent(font)-2); 
  scr.drawString(efont, i18n("Error"), baseline, int(x+2));
  
  x +=  Width(font) - 1;
}


void InsetError::Write(FILE *)
{
}

void InsetError::Read(LyXLex &)
{
}


int InsetError::Latex(FILE *, signed char /*fragile*/)
{
  return 0;
}


int InsetError::Latex(LString &, signed char /*fragile*/)
{
  return 0;
}


bool InsetError::AutoDelete() const
{
  return true;
}


unsigned char InsetError::Editable() const
{
  return EDITABLE_NO_UNDO;
}

void InsetError::Edit(int, int)
{
  if( !klyxdialogs->inserterror )
	klyxdialogs->inserterror = new InsertErrorDialog( current_view->getOwner() );

  klyxdialogs->inserterror->setError( contents.c_str() );

  (void)klyxdialogs->inserterror->exec();
}


Inset* InsetError::Clone()
{
  InsetError *result = new InsetError(contents);
  return result;
}
