// -*- C++ -*-
/* This file is part of*
 * ======================================================
 *
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *                        1996, 1997 LyX Team
 * 
 *======================================================*/

#ifndef _INSET_LOA_H
#define _INSET_LOA_H

#include <kapp.h>
#include <klocale.h>
#include "insetcommand.h"

// Created by Bernhard 970807

/** Used to insert table of algorithms
 */
class InsetLOA: public InsetCommand {
public:
	///
	InsetLOA(): InsetCommand("listofalgorithms") { }
	///
	InsetLOA(Buffer *b): InsetCommand("listofalgorithms"),owner(b){};
        ///
	void Validate(LaTeXFeatures &features) const;
        ///
        Inset* Clone() { return new InsetLOA(owner); }
    	///
	LString getScreenLabel() const { return klocale->translate("List of Algorithms"); }

	
	//void Edit(int, int);
        ///
	unsigned char Editable() const {
		return NOT_EDITABLE; // not yet
	}
	///
	bool Display() const { return true; }
	///
	Inset::Code LyxCode() const { return Inset::LOA_CODE; }
private:
	///
	Buffer *owner;
};

#endif
