/* This file is part of*
 * ======================================================
 *
 *           LyX, the High Level Document Processor
 * 	 
 *	    Copyright (C) 1997 LyX Team
 * 
 *======================================================*/


// Created by asierra 970813

#include <config.h>

#include "insetparent.h"
#include "filetools.h"
#include "BufferView.h"
#include "LyXView.h"
#include "lyxfunc.h"
#include "commandtags.h"


extern BufferView *current_view;


InsetParent::InsetParent(LString fn, Buffer* owner): InsetCommand("lyxparent")
{
    if (owner)
	setContents(MakeAbsPath(fn, OnlyPath(owner->getFileName())));
    else
	setContents(fn);
}

void InsetParent::Edit(int, int)
{    
    current_view->getOwner()->getLyXFunc()->Dispatch(LFUN_CHILDOPEN, 
						     getContents().c_str());
}

// LaTeX must just ignore this command
int InsetParent::Latex(FILE *file, signed char fragile)
{
    fprintf(file, "%%#{lyx}");
    InsetCommand::Latex(file, fragile);
    return 0;
}

// LaTeX must just ignore this command
int InsetParent::Latex(LString &file, signed char fragile)
{
    file += "%%#{lyx}";
    InsetCommand::Latex(file, fragile);
    return 0;
}
