/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
* 	 
*	    Copyright (C) 1995 Matthias Ettrich
*           Copyright (C) 1995-1998 The LyX Team.
*
*======================================================*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>

#include "klyx.h"

#include "lyx_gui.h"
#include "tex-strings.h"
#include "lyx_main.h"
#include "error.h"
#include "LyXView.h"
#include "buffer.h"
#include "lyxserver.h"
#include "lyxdraw.h"
#include "lyxrc.h"
#include "lyx_gui_misc.h"
#include "lyx_cb.h"


// 	$Id: lyx_gui.C,v 1.36 1999/02/05 07:53:09 kuepper Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: lyx_gui.C,v 1.36 1999/02/05 07:53:09 kuepper Exp $";
#endif /* lint */

extern LyXServer *lyxserver;
extern bool finished;	// flag, that we are quitting the program
extern BufferView* current_view;

/*FL_CMD_OPT cmdopt[] =
{
	{"-width", "*.width", XrmoptionSepArg, "690"},
	{"-height", "*.height", XrmoptionSepArg, "510"},
	{"-Reverse", "*.Reverse", XrmoptionNoArg, "1"},
	{"-Mono", "*.Mono", XrmoptionNoArg, "1"},
	{"-FastSelection", "*.FastSelection", XrmoptionNoArg, "1"},
	{"-MathColor", "*.MathColor", XrmoptionSepArg, "blue"},
	{"-MathFrameColor", "*.MathFrameColor", XrmoptionSepArg, "magenta"},
	{"-FootColor", "*.FootColor", XrmoptionSepArg, "red"},
	{"-LabelColor", "*.LabelColor", XrmoptionSepArg, "palegreen"},
	{"-FillColor", "*.FillColor", XrmoptionSepArg, "magenta"},
	{"-OnOffLineColor", "*.OnOffLineColor", XrmoptionSepArg, "magenta"},
	{"-LatexColor", "*.LatexColor", XrmoptionSepArg, "red"},
	{"-NoteColor", "*.NoteColor", XrmoptionSepArg, "yellow"},
	{"-NoteFrameColor", "*.NoteFrameColor", XrmoptionSepArg, "black"},
	{"-LightedColor", "*.LightedColor", XrmoptionSepArg, "gray80"},
	{"-BackgroundColor", "*.BackgroundColor", XrmoptionSepArg, "bisque"},
	{"-SelectionColor", "*.SelectionColor", XrmoptionSepArg, "lightblue"}
};
*/
int        width = 690;
int        height = 510;
int	   reverse_video = 0;
int	   mono_video = 0;
int	   fast_selection = 0;
char	   math_color[32] = "blue";
char	   math_frame_color[32] = "magenta";
char	   foot_color[32] = "red";
char	   label_color[32] = "palegreen";
char	   fill_color[32] = "magenta";
char	   on_off_line_color[32] = "magenta";
char	   latex_color[32] = "red";
char	   note_color[32] = "yellow";
char       note_frame_color[32] = "black";
char	   lighted_color[32] = "gray80";
char	   bright_color[32] = "gray90";
QColor     background_color;
char	   selection_color[32] = "lightblue";

#warning replace this with KConfig...
/*FL_resource res[] =
{
	{"width", "widthClass", FL_INT, &width, "690"},
	{"height", "heightClass", FL_INT, &height, "510"},
	{"Reverse", "reverseClass", FL_INT, &reverse_video, "0"},
	{"Mono", "monoClass", FL_INT, &mono_video, "0"},
	{"FastSelection", "selectionClass", FL_INT, &fast_selection, "0"},
	{"MathColor", "colorClass", FL_STRING, math_color, "blue", 31},
	{"MathFrameColor", "colorClass", FL_STRING, math_frame_color, "magenta", 31},
	{"FootColor", "colorClass", FL_STRING, foot_color, "red", 31},
	{"LabelColor", "colorClass", FL_STRING, label_color, "palegreen", 31},
	{"FillColor", "colorClass", FL_STRING, fill_color, "magenta", 31},
	{"OnOffLineColor", "colorClass", FL_STRING, on_off_line_color, "magenta", 31},
	{"LatexColor", "colorClass", FL_STRING, latex_color, "red", 31},
	{"NoteColor", "colorClass", FL_STRING, note_color, "yellow", 31},
	{"NoteFrameColor", "colorClass", FL_STRING, note_frame_color, "black", 31},
	{"LightedColor", "colorClass", FL_STRING, lighted_color, "gray80", 31},
	{"BrightColor", "colorClass", FL_STRING, bright_color, "gray90", 31},
	{"BackgroundColor", "colorClass", FL_STRING, b_c, "bisque", 31},
	{"SelectionColor", "colorClass", FL_STRING, selection_color, "lightblue", 31}
};
*/

LyXGUI* lyxGUI;

LyXGUI::LyXGUI(LyX *owner, int * /*argc */ , char * /* argv */ [], bool GUI)
	:_owner(owner)
{
	lyxGUI = this;

	gui = GUI;
	if (!gui)
		return;


	setDefaults();
	background_color = kapp->windowColor;

	// Make sure default screen is not larger than monitor
	if (width == 690 && height == 510) {
		Screen * scr=(DefaultScreenOfDisplay(kapp->topWidget()->x11Display()));
		if (HeightOfScreen(scr)-24<height)
			height = HeightOfScreen(scr)-24;
		if (WidthOfScreen(scr)-8<width)
			width = WidthOfScreen(scr)-8;
	}

}


// A destructor is always necessary  (asierra-970604)
LyXGUI::~LyXGUI() {
        // Lyxserver was created in this class so should be destroyed
        // here.  asierra-970604
        if (lyxserver) {
		delete lyxserver;
		lyxserver = 0;
	}
}


void LyXGUI::setDefaults()
{
  /*	FL_IOPT cntl;
	cntl.buttonFontSize = FL_NORMAL_SIZE;
	cntl.browserFontSize = FL_NORMAL_SIZE;
	cntl.labelFontSize = FL_NORMAL_SIZE;
	cntl.choiceFontSize = FL_NORMAL_SIZE;
	cntl.inputFontSize = FL_NORMAL_SIZE;
	cntl.menuFontSize  = FL_NORMAL_SIZE;
	cntl.borderWidth = -1;
	cntl.vclass = FL_DefaultVisual;*/
//	fl_set_defaults(FL_PDVisual
  /*			| FL_PDButtonFontSize
			| FL_PDBrowserFontSize
			| FL_PDLabelFontSize
			| FL_PDChoiceFontSize
			| FL_PDInputFontSize
			| FL_PDMenuFontSize
			| FL_PDBorderWidth, &cntl);*/
}


// This is called after we have parsed lyxrc
void LyXGUI::init()
{
	if (!gui)
		return;

	LyXView *view  = new LyXView(width, height);
	/* update parameters */
	view->redraw();
	/* initialize */
	view->init();

	// in 0.12 the initialisation of the LyXServer must be done here
	// 0.13 it should be moved again...

	#warning FIXME. lyxserver now depends on first view....
	//lyxserver = new LyXServer(view->getLyXFunc(), lyxrc->lyxpipes);
	lyxserver = 0;

	// This is to make sure we get the selection color
	getGC(gc_selection);
	// This is to make sure we set the background_pixels
	getGC(gc_clear);
}



int myXErrorHandler(Display *, XErrorEvent *){
  printf("XERROR! Ignore it.\n");
  return 0; // ignore Xerrors
};

void LyXGUI::runTime()
	/* This will usually be toolkit (GUI) specific. This is
	 * also usually the XEvent dispatcher of the GUI. */
{
	if (!gui)
		return;
	XSetErrorHandler(myXErrorHandler);
	qApp->exec();
}



void LyXGUI::newView(){
  LyXView *view  = new LyXView(width, height);
  /* update parameters */
  view->redraw();
  /* initialize */
  view->init();
}

void LyXGUI::deleteView(LyXView *view){
  view->toplevelWidget()->close();
}
