#include <qpopmenu.h>
#include <qkeycode.h>
#include <qfiledlg.h>
#include <qlayout.h>

#include <ktopwidget.h>
#include <kmenubar.h>
#include <ktablistbox.h>

#include <kapp.h>
#include <klocale.h>

#include "kpp_mainwidget.h"
#include "kpp_list.h"

pp_MainWidget::pp_MainWidget(const char *name)
  :KTopLevelWidget(name)
{
  QPopupMenu *proj=0, *view=0;

 /* set statusbar */
  sbar = new KStatusBar(this, "sbar");
  CHECK_PTR(sbar);
  sbar->show();
  
  setStatusBar(sbar);
   
  list=new pp_List(this, "Vorgangsliste");
  //  setView(list, FALSE);
  list->show();

  menu=new KMenuBar(this, 0);
  file=new QPopupMenu ;
  file->insertItem("&Open",list,SLOT(loadFile()), CTRL+Key_O);
  file->insertItem("&Save",1);
  file->insertItem("Save &as");
  file->insertItem("Quit", KApplication::getKApplication(), SLOT(quit()), ALT+Key_Q);

  //menu->setMenuBarPos(Top);
  edit = new QPopupMenu;
//  edit->setTitle("Edit");
  edit->insertItem("&New Task", list, SLOT(newEntry()) , CTRL+Key_N);
  edit->insertItem("&Edit Task", list, SLOT(editEntry()), CTRL+Key_E);
  edit->insertItem("&Delete Task", list, SLOT(deleteEntry()), CTRL+Key_D);
  
  proj=new QPopupMenu;
  proj->insertItem("&Calculate Times", list, SLOT(calcTimes()), CTRL+Key_C);  
  
  view=new QPopupMenu;
  view->insertItem("&Gantt", list, SLOT(showGantt()), CTRL+Key_G);  
  
  /* "assemble" menu */
  menu->insertItem("File",file);
  menu->insertItem("Edit",edit);
  menu->insertItem("View",view);
  menu->insertItem("Project",proj);
  setMenu(menu);

  
  setView(list, TRUE);  

 
  /* signal and slot maintanance */  
  connect(list, SIGNAL(change(QString)), this, SLOT(updateStatus(QString)));
}

pp_MainWidget::~pp_MainWidget()
{
  delete menu;
  delete file;
  delete edit;
  delete list;
  delete sbar;
}

/* react on listbox change event */
void pp_MainWidget::changeEntry(int, int)
{
}

void pp_MainWidget::updateStatus(QString sz)
{
   sbar->changeItem((const char *)sz, 0);
   sbar->show();
}



