#include "ksiag_header.h"
#include <qpen.h>

#include "../siag/calc.h"
#include "siagcallbacks.h"

extern window *w_list;

KSiagHeader::KSiagHeader (KSiagTable *table, QWidget *parent, const char *name)
    : QWidget(parent, name)
{
    fnt = new QFont();
    tbl = table;
    top = 0;
    inresize = incursor = 0;
    setMouseTracking(true);
}

KSiagHeader::~KSiagHeader()
{
    delete fnt;
}

void KSiagHeader::setTopCell (int cell)
{
    top = cell;
    repaint();
}

void KSiagHorizHeader::mousePressEvent (QMouseEvent *ev)
{
    cell = tbl->findCol(ev->x());
    if (incursor)
        inresize = 1;
    else{
        set_point_col(w_list, tbl->findCol(ev->x())+1);
        set_mark_col(w_list, tbl->findCol(ev->x())+1);
        set_point_row(w_list, 1);
        set_mark_row(w_list, BUFFER_ROWS);
        set_block();
        tbl->setCursor();
        tbl->repaint();
    }
}

void KSiagVertHeader::mousePressEvent (QMouseEvent *ev)
{
    cell = tbl->findRow(ev->y());
    if (incursor)
        inresize = 1;
    else{
        set_point_row(w_list, tbl->findRow(ev->y())+1);
        set_mark_row(w_list, tbl->findRow(ev->y())+1);
        set_point_col(w_list, 1);
        set_mark_col(w_list, BUFFER_COLS);
        set_block();
        tbl->setCursor();
        tbl->repaint();
    }
}

void KSiagHorizHeader::mouseReleaseEvent (QMouseEvent *ev)
{
    int pos;
    if (inresize){
        setCursor(arrowCursor);
        inresize = 0;
        tbl->colXPos(cell-1, &pos);
        if (ev->x() >= pos+5){
            set_width(w_list->buf, cell, ev->x()-pos);
            tbl->resetBuffer();
        }
    }
    repaint();
    oldpos = 0;
}

void KSiagVertHeader::mouseReleaseEvent (QMouseEvent *ev)
{
    int pos;
    if (inresize){
        setCursor(arrowCursor);
        inresize = 0;
        tbl->rowYPos(cell-1, &pos);
        if (ev->y() >= pos+5){
            set_height(w_list->buf, cell, ev->y()-pos);
            tbl->resetBuffer();
        }
    }
    repaint();
    oldpos = 0;
}

void KSiagHorizHeader::mouseMoveEvent (QMouseEvent *ev)
{
    int pos;
    if (inresize)
        drawMoveLine(ev->x());
    else{
        pos = tbl->findCol(ev->x());
        tbl->colXPos(pos, &pos);
        if (ev->x() > pos-2 && ev->x() < pos+2){
            if (!incursor){
                setCursor(sizeHorCursor);
                incursor = 1;
            }
        }
        else{
            if (incursor){
                setCursor(arrowCursor);
                incursor = 0;
            }
        }
    }
}

void KSiagVertHeader::mouseMoveEvent (QMouseEvent *ev)
{
    int pos;
    if (inresize)
        drawMoveLine(ev->y());
    else{
        pos = tbl->findRow(ev->y());
        tbl->rowYPos(pos, &pos);
        if (ev->y() > pos-2 && ev->y() < pos+2){
            if (!incursor){
                setCursor(sizeVerCursor);
                incursor = 1;
            }
        }
        else{
            if (incursor){
                setCursor(arrowCursor);
                incursor = 0;
            }
        }
    }
}

void KSiagHorizHeader::drawMoveLine(int pos)
{
    QPainter p;
    p.begin(this);
    p.setPen(black);
    p.setRasterOp(NotROP);
    if (oldpos)
        p.drawLine(oldpos, 0, oldpos, height());
    p.drawLine(pos, 0, pos, height());
    p.end();
    p.begin(tbl);
    p.setPen(DotLine);
    p.setRasterOp(NotROP);
    if (oldpos)
        p.drawLine(oldpos, 0, oldpos, tbl->height());
    p.drawLine(pos, 0, pos, tbl->height());
    p.end();
    oldpos = pos;

}

void KSiagVertHeader::drawMoveLine(int pos)
{
    QPainter p;
    p.begin(this);
    p.setPen(black);
    p.setRasterOp(NotROP);
    if (oldpos)
        p.drawLine(0, oldpos, width(), oldpos);
    p.drawLine(0, pos, width(), pos);
    p.end();
    p.begin(tbl);
    p.setPen(DotLine);
    p.setRasterOp(NotROP);
    if (oldpos)
        p.drawLine(0, oldpos, tbl->width(), oldpos);
    p.drawLine(0, pos, tbl->width(), pos);
    p.end();
    oldpos = pos;
}
                              
void KSiagHorizHeader::paintEvent (QPaintEvent *ev)
{
    int pos, oldpos, cell=top;
    int w = this->width(), h = this->height();
    QPainter p;

    p.begin (this);
    p.fillRect (0, 0, w, h, QBrush(colorGroup().background()));
    p.setPen (colorGroup().dark());
    p.drawLine (0, h-1, w, h-1);
    p.setPen (colorGroup().light());
    p.drawLine (0, 0, w, 0);
    pos = 0;
    while (pos <= w){
        p.setPen(white);
        p.drawLine (pos, 0, pos, h-2);
        oldpos = pos;
        pos += tbl->cellWidth(cell);
        p.setPen(colorGroup().dark());
        p.drawLine (pos-1, 0, pos-1, h-2);
        ++cell;
        p.setPen(black);
        //sprintf (text, "%d", cell);
        p.drawText (oldpos, 0, pos-oldpos, h, AlignCenter, colnum_text(cell));
    }
    p.end();
}

void KSiagVertHeader::paintEvent (QPaintEvent *ev)
{
    int pos, oldpos, cell=top;
    int w = this->width(), h = this->height();
    QPainter p;

    p.begin (this);
    p.fillRect (0, 0, w, h, QBrush(colorGroup().background()));
    p.setPen (colorGroup().dark());
    p.drawLine (w-1, 0, w-1, h);
    p.setPen (colorGroup().light());
    p.drawLine (0, 0, 0, h);
    pos = 0;
    while (pos <= h){
        p.setPen(colorGroup().light());
        p.drawLine (0, pos, w-2, pos);
        oldpos = pos;
        pos += tbl->cellHeight(cell);
        p.setPen(colorGroup().dark());
        p.drawLine (0, pos-1, w-2, pos-1);
        ++cell;
        p.setPen(black);
        sprintf (text, "%d", cell);
        p.drawText (0, oldpos, w, pos-oldpos, AlignCenter, text);
    }
    p.end();
}
