
#ifndef __KSIAGTABLEVIEW
#define __KSIAGTABLEVIEW

#include "ksiag_table.h"
#include "ksiag_header.h"
#include "ksiag_tabbar.h"
#include <qscrollbar.h>

/**
 * This handles the table decorations. Currently table headers, the little
 * "goto top" button, and the document tabbar.
 */

class KSiagTableView : public QWidget
{
    Q_OBJECT
public:
    KSiagTableView(window *w, QWidget *parent=0, const char *name=0);
    KSiagTable* table(){return(tbl);}
    void addBufferTab (const char *name);
    bool removeBufferTab (const char *name);
    bool changeBufferTab (const char *name, const char *newname);
    void setActiveTab (const char *name){tabbar->setActiveTab(name);}
public slots:
    void positionPlugins();
    void setLeftCell (int col);
    void setTopCell (int row);
    void gotoTop();
    void resetBuffer();
    void repaintAll ();
    void setActiveBuffer(const char *name);
signals:
    /**
     * This should be connected to by KSiagTableManager.
     */
    void activateBuffer (KSiagTableView *table, const char *name);
protected:
    KSiagTabBar *tabbar;
    KSiagTable *tbl;
    KSiagHorizHeader *hheader;
    KSiagVertHeader  *vheader;
    QScrollBar *hscroll, *vscroll;
};


#endif

