/* editstock.cpp
 *
 * Andreas Wst
 *
 */
 
#include "editstock.moc"


EditStock::EditStock ( QWidget *parent, const char *name, int anz, 
                      Stock *stock [])
                : QDialog ( parent, name, TRUE )
{

  for (int i = 0; i < anz; i++)
    s [i] = stock [i];

  bgedit = new QButtonGroup( this, "ButtonGroup_2" );
  bgedit->setGeometry( 270, 20, 290, 240 );
  bgedit->setFrameStyle( 49 );
  bgedit->setTitle( "Edit" );
  bgedit->setAlignment( 1 );
  bgedit->lower();

  bg = new QButtonGroup( this, "ButtonGroup_1" );
  bg->setGeometry( 20, 20, 230, 240 );
  bg->setFrameStyle( 49 );
  bg->setTitle( "Selection" );
  bg->setAlignment( 1 );
  bg->lower();

  lb = new QListBox( bg, "ListBox_1" );
  lb->setGeometry( 20, 30, 190, 190 );
  lb->setFrameStyle( 51 );
  lb->setLineWidth( 2 );

  for (int i = 0; i < anz; i++)
  {
    s [i] = stock [i];
    lb->insertItem (s [i]->getName ());
  }


  QLabel *l;
  l = new QLabel( bgedit, "Label_1" );
  l->setGeometry( 10, 50, 80, 20 );
  l->setText( "Name :" );
  l->setAlignment( 290 );
  l->setMargin( -1 );

  l = new QLabel( bgedit, "Label_2" );
  l->setGeometry( 20, 90, 70, 20 );
  l->setText( "WKN :" );
  l->setAlignment( 290 );
  l->setMargin( -1 );

  l = new QLabel( bgedit, "Label_3" );
  l->setGeometry( 20, 130, 70, 20 );
  l->setText( "Number :" );
  l->setAlignment( 290 );
  l->setMargin( -1 );

  l = new QLabel( bgedit, "Label_4" );
  l->setGeometry( 20, 170, 70, 20 );
  l->setText( "Price :" );
  l->setAlignment( 290 );
  l->setMargin( -1 );

  le [0] = new QLineEdit( bgedit, "LineEdit_1" );
  le [0]->setGeometry( 110, 50, 160, 20 );
  le [0]->setText( "" );
  le [0]->setMaxLength( 50 );
  le [0]->setEchoMode( QLineEdit::Normal );
  le [0]->setFrame( TRUE );

  le [1] = new QLineEdit( bgedit, "LineEdit_2" );
  le [1]->setGeometry( 110, 90, 160, 20 );
  le [1]->setText( "" );
  le [1]->setMaxLength( 7 );
  le [1]->setEchoMode( QLineEdit::Normal );
  le [1]->setFrame( TRUE );

  le [2] = new QLineEdit( bgedit, "LineEdit_3" );
  le [2]->setGeometry( 110, 130, 160, 20 );
  le [2]->setText( "" );
  le [2]->setMaxLength( 10 );
  le [2]->setEchoMode( QLineEdit::Normal );
  le [2]->setFrame( TRUE );

  le [3] = new QLineEdit( bgedit, "LineEdit_4" );
  le [3]->setGeometry( 110, 170, 160, 20 );
  le [3]->setText( "" );
  le [3]->setMaxLength( 10 );
  le [3]->setEchoMode( QLineEdit::Normal );
  le [3]->setFrame( TRUE );

  ok = new QPushButton( this, "PushButton_1" );
  ok->setGeometry( 460, 290, 100, 30 );
  ok->setText( "OK" );
  connect (ok, SIGNAL (clicked ()), this, SLOT (useData ()));
  connect (this, SIGNAL (doneOK ()), SLOT (accept ()));

  cancel = new QPushButton( this, "PushButton_2" );
  cancel->setGeometry( 330, 290, 100, 30 );
  cancel->setText( "Cancel" );
  connect (cancel, SIGNAL (clicked ()), this, SLOT (reject ()));

  connect (lb, SIGNAL (highlighted (int)), SLOT (putSelectedInEdit (int)));

  resize( 580, 340 );


}


EditStock::~EditStock()
{
  
}

void EditStock::putSelectedInEdit (int index)
{
  char st [10];
  le [0]->setText (s [index]->getName ());
  le [1]->setText (s [index]->getWKN ());
  
  sprintf (st, "%d", s [index]->getAnzahl ());
  le [2]->setText (st);
  
  sprintf (st, "%.2f", s [index]->getKaufKurs ());
  le [3]->setText (st);
}


void EditStock::useData()
{ 
  QString n, w, st;
  int nr;
  double k;

  bool ok = TRUE;

  // Name holen
  n = le [0]->text ();
  debug ("gelesen : %s", n.data ());
 
  // WKN holen
  w = le [1]->text ();
 
  // Anzahl holen
  st = le [2]->text ();
  nr = st.toInt (&ok);
  
  // Kaufkurs holen
  st = le [3]->text ();
  k = st.toDouble (&ok);

  if (ok == FALSE || n.length () == 0 || w.length () == 0)
  {
    KMsgBox::message (this, "Error", "Input Error !");
    return;
  }

  int index = lb->currentItem ();

  debug ("index : %d", index);  

  s [index]->setName (n.data ());
  s [index]->setWKN (w.data ());
  s [index]->setAnzahl (nr);
  s [index]->setKaufKurs (k);


  debug ("after editstock : neuer name %s", s [index]->getName ());
  debug ("after editstock : neuer name %s", n.data ());
 
 
  emit (doneOK ());
}

