/* MyWidget.h
 *
 * Andreas Wst
 */

#ifndef MYWIDGET_H
#define MYWIDGET_H


#include "includes.h"


// globale strukturen 
#include "structs.h"

#include "stock.h"
#include "addstock.h"
#include "editstock.h"
#include "kill.h"
#include "merge.h"
#include "newakt.h"
#include "wknsuche.h"
#include "split.h"
#include "config_dialog.h"
#include "stockinfo.h"
#include "showchart.h"
#include "newdeposit.h"

#define WIDTH     720
#define HEIGHT    460

#define ID_QUIT   2000
#define ID_NEW    2001
#define ID_OPEN   2002
#define ID_SAVE   2003
#define ID_HELP   2010

 
/**
 * This is the class MyWidget. The class is used only for the program 
 * MyWidget.
 * 
 * @short Basic class for MyWidget
 * @author Andreas Wst
 * @version 0.00
 * 
 */

class MyWidget : public KTopLevelWidget
{
	Q_OBJECT

public:
	
	// The constructor method for class KFortune
	//
	// @see MyWidget
	// @param parent Parent widget, used for QWidget
	// @param name	Name for QWidget
	 	 
	MyWidget ( QWidget *parent=0, const char *name=0 );
	
	// The destrucor method for class KFortune
	
	~MyWidget();
		

 
  // enum wie in kmenubar
  enum menuPosition { Top, Bottom, Floating};

protected:

  // lscht preceeding nullen in string 
  char * killOhs (char *);

  // ldt logos der aktien des depots
  void loadLogos ();

  // gesamtperformance berechnen
  void calculateOverallPerformance ();

  // sichert DepotDaten in Datei
  void saveDepotData (const char *);
  
  // ldt DeoptDaten aus Datei
  void loadDepotData (const char *);

  // fgt Aktie in ListView ein
  void putStockInListView (Stock);



	// @see KKeyConfig
	void initKeys();

	// Creates the menubar and connects the menu-entries to the
	// appropriate functions
	void createMenu();

        void createToolBar ();

        // Get the configuration from the config-file.
	void initConfig ();

	// Save the current configuration to the config-file.
	void saveConfig();


  // paint event fr logo
  void paintEvent (QPaintEvent *);



  KConfig *config;
  //  KStdAccel *accel;



  KMenuBar *menu;
  KToolBar *tb;
  QPopupMenu *file, *options, *help, *stocks, *chart, *suche, *popup;
  QPopupMenu *popyahoo, *popcbs, *popquicken;
 
  // container widget, enthlt alle elemente bis auf toolbar, menubar
  // mit setview aktiviert um floating menubars zu handeln
  QWidget *container;

	

  QListView *lv;
  QFrame *fr, *fr2;
  QGroupBox *gb1, *gb2, *gb3;


  QLabel *linvest, *laktinvest, *lproz, *leuro, *lcur;
  QLabel *llogo;

  Stock *stock [30], *currentStock;

  int gesanz;

 

public slots:

  //  wenn icon auf toolbar angeklickt wurde, wird diese funktion aufgerufen
  void getToolBarOption (int);

  // erhlt vom newdeposit dialog namen und whrung
  void getDepositData (QString, unsigned char);

  // ffnet stockinfo dialog -> listview mit allen aktien
  void stockInfoDialog ();

  // startet browser mit entsprechender seite
  void startBrowser (int);

  // stock news at zacks
  void openBrowserWithZacks ();

  // Stock quotes cnnfn
  void openBrowserWithCNNFN ();

  // CBS Market Watch -> NEWS
  void openBrowserWithCBSMarketWatchNews ();

  // CBS Market Watch -> HOME
  void openBrowserWithCBSMarketWatchHome ();

  // YAHOO GRADES 
  void openBrowserWithYahooGrades ();

  // QUICKEN HOME 
  void openBrowserWithQuickenQuote ();

  // QUICKEN SNAPSHOT
  void openBrowserWithQuickenSnapshot ();

  // YAHOO HOME -> Netscape mit auf Krzelseite ffnen
  void openBrowserWithYahooHome ();


  // popup dialog fr aktien in listview
  void openPopupInListView (QListViewItem *, const QPoint &, int);

  // configuration fr gesamtes programm einstellen
  void setConfig ();

  // erhlt aktuelles listviewitem
  void getCurrentItem (QListViewItem *);

  // neubar bewegt !
  void getMenuBarPos (menuPosition);

  // split dialog ffnen
  void showSplit ();

  // Chart anzeigen
  void showChart ();

  // Dialog zur WKN suche
  void sucheWKN ();

  // Dialog um aktuelle Kurse einzugeben
  void editAktKurse ();

  // mischkurs zweier aktien berechnen
  void mergeStocks ();
 
  // aktie wieder lschen
  void killStock ();

  // wurde aktie hinzugefgt
  void getAdded (bool);

  //  auswahl zum editieren
  void editStock ();

  // bernimmt Stock von AddStock
  void getStock (Stock);

  // Dialog zum erstellen einer neuen Aktien
  void newDialog ();

  // Sichern des akt. Depots in currentdepot
  void saveDepot ();

  // Dialog zum Sichern von Depots
  void saveDialog ();

  // Dialog zum Laden von Depots
  void loadDialog ();
        
  // Neues Depot -> alle alten Eintrge lschen
  void newDepot ();


        // Quit the application
	void quitapp();

	// Shows a message telling the user that a function has
	// not been implemented yet.
	void notImpl();
	
	// Shows a window for configuring the keybindings
	//	void configkeys();

	// Shows information about the program
	void about();

	// Show the online-help
	void helpmenu();


protected :

  struct CONFIGURATION_DATA config_data;


  char gifname [20];
  QString currentdepot;

  // pfad + name des depots
  QString deposit_name;

  // currency des depots 
  // 0 - Euro   1 - Dollar   2 - Yen
  unsigned char deposit_currency;

  int logoy;

  static const char cur [4];
};

#endif
