/* namesuche.cpp
 *
 * Andreas Wst
 *
 */

#include "namesuche.moc"

NameSuche::NameSuche ( QWidget *parent, const char *name )
                : QDialog ( parent, name, TRUE )
{
  setCaption ("Look for stock");

  bg = new QButtonGroup ("Look for stock",  this, "ButtonGroup_1" );
  bg->setGeometry( 10, 20, 330, 260 );
  bg->setFrameStyle( 49 );
  bg->lower();

  le = new QLineEdit (bg, "LineEdit_1" );
  le->setGeometry( 120, 30, 160, 20 );
  le->setMaxLength( 20 );
  connect (le, SIGNAL (textChanged (const char *)), 
           SLOT (sucheString (const char *)));

  QLabel *l = new QLabel ("Name :", bg, "Label_1" );
  l->setGeometry( 10, 30, 75, 20 );
  l->setAlignment( 290 );


  lb = new QListBox(bg, "ListBox_1" );
  lb->setGeometry( 20, 70, 290, 170 );
  lb->setFrameStyle( 51 );
  lb->setLineWidth( 2 );
  lb->setAutoBottomScrollBar (FALSE);

  ok = new QPushButton ("OK", this, "PushButton_1" );
  ok->setGeometry( 270, 290, 70, 30 );
  connect (ok, SIGNAL (clicked ()), SLOT (accept ()));

  resize( 360, 340 );
  
  sucheString ("");

}

char * NameSuche::removeSpaces (char *s)
{
  //  debug (s);
  int i = strlen (s);
  while (s [i - 1] == ' ')
  {
    s [i] = 0;
    i--;
  }
  return s;
}


void NameSuche::sucheString (const char *vgl)
{
  debug ("suche stirng");

  FILE *in;
  char st [80], dummy [50];

  const char markt [7] [20] = {" (DAX)", " (EURO-STOXX 50)", " (M-DAX)", 
                               " (Neuer Markt)", " (Ausland)", " (Dow Jones)",
                               " (EASDAQ)"};

  strcpy (st, (const char *) getenv ("KDEDIR"));
  strcat (st, "/share/apps/kstocks/l.list");

  if (lb->count () != 0) 
  {
    //    debug ("anzahl : %d",lb->count ());
    //    debug ("\n\nclear");
    lb->clear ();
  }
  else
  {
    debug ("listbox leer");
  }

  
  if ((in = fopen (st, "rt")) == NULL)
  {
    fprintf (stderr, "Error opening l.list - file !");
  }
  else
  {   
    while (fgets (st, 78, in) != NULL)
    {
      // alles einfgen
      if (strlen (vgl) == 0)
      {
        // wkn
        memset (dummy, 0, sizeof (dummy));
        memcpy (&dummy [0], st, 7), 
        dummy [7] = ' ';
        // name
        memcpy (&dummy [8], &st [37], 30);
        strcpy (dummy, removeSpaces (dummy));
        strcat (&dummy [strlen (dummy) - 1], 
                markt [(int) st [8] - 48]);
        lb->insertItem (dummy);
      }

      else  // vergleichen
      { 
        memset (dummy, 0, sizeof (dummy));
        memcpy (dummy, &st [37], 30);

        if (strncmp (vgl, dummy, strlen (vgl)) == 0)
	{
          memset (dummy, 0, sizeof (dummy));
          memcpy (&dummy [0], st, 7), 
          dummy [7] = ' ';
          memcpy (&dummy [8], &st [37], 30);
          strcpy (dummy, removeSpaces (dummy));
          strcat (&dummy [strlen (dummy) - 1], 
                  markt [(int) st [8] - 48]);
          lb->insertItem (dummy);
	} 
      }

    }
  }


  fclose (in);
}

NameSuche::~NameSuche()
{
        
}
