/***************************************************************************
                          kpreferences.cpp  -  description
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include <string>
#include "kpreferences.h"

#define Inherited KDialog

Preferences::Preferences
(   	KApplication *a,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name, TRUE )
{
	mykapp = a;

	config = mykapp->getConfig();
	read_preferences();
	
	autoloadaddressbook	=default_autoloadaddressbook;
	autoexportkmail		=default_autoexportkmail;
	autoexportkab		=default_autoexportkab;
	autosaveonquit		=default_autosaveonquit;
	vcardextensions		=default_vcardextensions;
	small			=default_small;
	medium			=default_medium;
	complete		=default_complete;
	overcomplete		=default_overcomplete;
	date			=default_date;
	
	config->sync();
	write_preferences();
	this->setCaption(i18n("Preferences"));
	ButtonGroup_Preferences = new QButtonGroup( this, "ButtonGroup_Preferences" );
	ButtonGroup_Preferences->setGeometry( 0, 0, 250, 330 );
	ButtonGroup_Preferences->setMinimumSize( 0, 0 );
	ButtonGroup_Preferences->setMaximumSize( 32767, 32767 );
	ButtonGroup_Preferences->setFocusPolicy( QWidget::NoFocus );
	ButtonGroup_Preferences->setBackgroundMode( QWidget::PaletteBackground );
	ButtonGroup_Preferences->setFontPropagation( QWidget::NoChildren );
	ButtonGroup_Preferences->setPalettePropagation( QWidget::NoChildren );
	ButtonGroup_Preferences->setFrameStyle( 49 );
	ButtonGroup_Preferences->setLineWidth( 1 );
	ButtonGroup_Preferences->setMidLineWidth( 0 );
	ButtonGroup_Preferences->QFrame::setMargin( 0 );
	ButtonGroup_Preferences->setTitle( i18n("Preferences" ));
	ButtonGroup_Preferences->setAlignment( 1 );
	ButtonGroup_Preferences->setExclusive( FALSE );

	CheckBox_AutoLoadAddressBook = new QCheckBox( this, "CheckBox_AutoLoadAddressBook" );
	CheckBox_AutoLoadAddressBook->setGeometry( 10, 20, 220, 30 );
	CheckBox_AutoLoadAddressBook->setMinimumSize( 0, 0 );
	CheckBox_AutoLoadAddressBook->setMaximumSize( 32767, 32767 );
	connect( CheckBox_AutoLoadAddressBook, SIGNAL(toggled(bool)), SLOT(slot_kpreferences_autoloadaddressbook(bool)) );
	CheckBox_AutoLoadAddressBook->setFocusPolicy( QWidget::TabFocus );
	CheckBox_AutoLoadAddressBook->setBackgroundMode( QWidget::PaletteBackground );
	CheckBox_AutoLoadAddressBook->setFontPropagation( QWidget::NoChildren );
	CheckBox_AutoLoadAddressBook->setPalettePropagation( QWidget::NoChildren );
	CheckBox_AutoLoadAddressBook->setText( i18n("Auto-Load of AddressBook" ));
	CheckBox_AutoLoadAddressBook->setAutoRepeat( FALSE );
	CheckBox_AutoLoadAddressBook->setAutoResize( FALSE );
	CheckBox_AutoLoadAddressBook->setChecked( default_autoloadaddressbook );

	CheckBox_AutoExportKmail = new QCheckBox( this, "CheckBox_AutoExportKmail" );
	CheckBox_AutoExportKmail->setGeometry( 10, 50, 220, 30 );
	CheckBox_AutoExportKmail->setMinimumSize( 0, 0 );
	CheckBox_AutoExportKmail->setMaximumSize( 32767, 32767 );
	connect( CheckBox_AutoExportKmail, SIGNAL(toggled(bool)), SLOT(slot_kpreferences_autoexportkmail(bool)) );
	CheckBox_AutoExportKmail->setFocusPolicy( QWidget::TabFocus );
	CheckBox_AutoExportKmail->setBackgroundMode( QWidget::PaletteBackground );
	CheckBox_AutoExportKmail->setFontPropagation( QWidget::NoChildren );
	CheckBox_AutoExportKmail->setPalettePropagation( QWidget::NoChildren );
	CheckBox_AutoExportKmail->setText( i18n("Auto-Export to Kmail AddressBook" ));
	CheckBox_AutoExportKmail->setAutoRepeat( FALSE );
	CheckBox_AutoExportKmail->setAutoResize( FALSE );
	CheckBox_AutoExportKmail->setChecked( default_autoexportkmail );

	CheckBox_AutoExportKab = new QCheckBox( this, "CheckBox_AutoExportKab" );
	CheckBox_AutoExportKab->setGeometry( 10, 80, 220, 30 );
	CheckBox_AutoExportKab->setMinimumSize( 0, 0 );
	CheckBox_AutoExportKab->setMaximumSize( 32767, 32767 );
	connect( CheckBox_AutoExportKab, SIGNAL(toggled(bool)), SLOT(slot_kpreferences_autoexportkab(bool)) );
	CheckBox_AutoExportKab->setFocusPolicy( QWidget::TabFocus );
	CheckBox_AutoExportKab->setBackgroundMode( QWidget::PaletteBackground );
	CheckBox_AutoExportKab->setFontPropagation( QWidget::NoChildren );
	CheckBox_AutoExportKab->setPalettePropagation( QWidget::NoChildren );
	CheckBox_AutoExportKab->setText( i18n("Auto-Export to Kab" ));
	CheckBox_AutoExportKab->setAutoRepeat( FALSE );
	CheckBox_AutoExportKab->setAutoResize( FALSE );
	CheckBox_AutoExportKab->setChecked( default_autoexportkab );

	CheckBox_AutoSaveonQuit = new QCheckBox( this, "CheckBox_AutoSaveonQuit" );
	CheckBox_AutoSaveonQuit->setGeometry( 10, 110, 210, 30 );
	CheckBox_AutoSaveonQuit->setMinimumSize( 0, 0 );
	CheckBox_AutoSaveonQuit->setMaximumSize( 32767, 32767 );
	connect( CheckBox_AutoSaveonQuit, SIGNAL(toggled(bool)), SLOT(slot_kpreferences_autosaveonquit(bool)) );
	CheckBox_AutoSaveonQuit->setFocusPolicy( QWidget::TabFocus );
	CheckBox_AutoSaveonQuit->setBackgroundMode( QWidget::PaletteBackground );
	CheckBox_AutoSaveonQuit->setFontPropagation( QWidget::NoChildren );
	CheckBox_AutoSaveonQuit->setPalettePropagation( QWidget::NoChildren );
	CheckBox_AutoSaveonQuit->setText( i18n("Auto-Save AddressBook on Quit" ));
	CheckBox_AutoSaveonQuit->setAutoRepeat( FALSE );
	CheckBox_AutoSaveonQuit->setAutoResize( FALSE );
	CheckBox_AutoSaveonQuit->setChecked( default_autosaveonquit );
	
	PushButton_VcardDirectory = new QPushButton (this,"VcardDirectory");
	PushButton_VcardDirectory->setGeometry( 220 , 110, 20, 30 );
	PushButton_VcardDirectory->setMinimumSize( 0, 0 );
	PushButton_VcardDirectory->setMaximumSize( 20, 30 );
	connect( PushButton_VcardDirectory, SIGNAL(clicked()), SLOT(slot_kpreferences_vcarddirectory()) );
	PushButton_VcardDirectory->setFocusPolicy( QWidget::TabFocus );
	PushButton_VcardDirectory->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_VcardDirectory->setFontPropagation( QWidget::NoChildren );
	PushButton_VcardDirectory->setPalettePropagation( QWidget::NoChildren );
	PushButton_VcardDirectory->setText( i18n("..." ));
	PushButton_VcardDirectory->setAutoRepeat( FALSE );
	PushButton_VcardDirectory->setAutoResize( FALSE );
	PushButton_VcardDirectory->setToggleButton( FALSE );
	PushButton_VcardDirectory->setDefault( FALSE );
	PushButton_VcardDirectory->setAutoDefault( FALSE );
	PushButton_VcardDirectory->setIsMenuButton( FALSE );
	
	CheckBox_VcardExtensions = new QCheckBox( this, "CheckBox_VcardExtensions" );
	CheckBox_VcardExtensions->setGeometry( 10, 140, 210, 30 );
	CheckBox_VcardExtensions->setMinimumSize( 0, 0 );
	CheckBox_VcardExtensions->setMaximumSize( 32767, 32767 );
	connect( CheckBox_VcardExtensions, SIGNAL(toggled(bool)), SLOT(slot_kpreferences_vcardextensions(bool)) );
	CheckBox_VcardExtensions->setFocusPolicy( QWidget::TabFocus );
	CheckBox_VcardExtensions->setBackgroundMode( QWidget::PaletteBackground );
	CheckBox_VcardExtensions->setFontPropagation( QWidget::NoChildren );
	CheckBox_VcardExtensions->setPalettePropagation( QWidget::NoChildren );
	CheckBox_VcardExtensions->setText( i18n("Display Vcards with Extensions" ));
	CheckBox_VcardExtensions->setAutoRepeat( FALSE );
	CheckBox_VcardExtensions->setAutoResize( FALSE );
	CheckBox_VcardExtensions->setChecked( default_vcardextensions);
	
	PushButton_VcardExtensionsDirectory = new QPushButton (this,"VcardExtensionsDirectory");
	PushButton_VcardExtensionsDirectory->setGeometry( 220 , 140, 20, 30 );
	PushButton_VcardExtensionsDirectory->setMinimumSize( 0, 0 );
	PushButton_VcardExtensionsDirectory->setMaximumSize( 20, 30 );
	connect( PushButton_VcardExtensionsDirectory, SIGNAL(clicked()), SLOT(slot_kpreferences_vcardextensionsdirectory()) );
	PushButton_VcardExtensionsDirectory->setFocusPolicy( QWidget::TabFocus );
	PushButton_VcardExtensionsDirectory->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_VcardExtensionsDirectory->setFontPropagation( QWidget::NoChildren );
	PushButton_VcardExtensionsDirectory->setPalettePropagation( QWidget::NoChildren );
	PushButton_VcardExtensionsDirectory->setText( i18n("..." ));
	PushButton_VcardExtensionsDirectory->setAutoRepeat( FALSE );
	PushButton_VcardExtensionsDirectory->setAutoResize( FALSE );
	PushButton_VcardExtensionsDirectory->setToggleButton( FALSE );
	PushButton_VcardExtensionsDirectory->setDefault( FALSE );
	PushButton_VcardExtensionsDirectory->setAutoDefault( FALSE );
	PushButton_VcardExtensionsDirectory->setIsMenuButton( FALSE );
	
	RadioButton_SmallVcards = new QRadioButton( this, "RadioButton_SmallVcards" );
	RadioButton_SmallVcards->setGeometry( 10, 170, 210, 30 );
	RadioButton_SmallVcards->setMinimumSize( 0, 0 );
	RadioButton_SmallVcards->setMaximumSize( 32767, 32767 );
	connect( RadioButton_SmallVcards, SIGNAL(toggled(bool)), SLOT(slot_kpreferences_small(bool)) );
	RadioButton_SmallVcards->setFocusPolicy( QWidget::TabFocus );
	RadioButton_SmallVcards->setBackgroundMode( QWidget::PaletteBackground );
	RadioButton_SmallVcards->setFontPropagation( QWidget::NoChildren );
	RadioButton_SmallVcards->setPalettePropagation( QWidget::NoChildren );
	RadioButton_SmallVcards->setText( i18n("Display Small Vcards" ));
	RadioButton_SmallVcards->setAutoRepeat( FALSE );
	RadioButton_SmallVcards->setAutoResize( FALSE );
	RadioButton_SmallVcards->setChecked( default_small );

	RadioButton_MediumVcards = new QRadioButton( this, "RadioButton_MediumVcards" );
	RadioButton_MediumVcards->setGeometry( 10, 200, 210, 30 );
	RadioButton_MediumVcards->setMinimumSize( 0, 0 );
	RadioButton_MediumVcards->setMaximumSize( 32767, 32767 );
	connect( RadioButton_MediumVcards, SIGNAL(toggled(bool)), SLOT(slot_kpreferences_medium(bool)) );
	RadioButton_MediumVcards->setFocusPolicy( QWidget::TabFocus );
	RadioButton_MediumVcards->setBackgroundMode( QWidget::PaletteBackground );
	RadioButton_MediumVcards->setFontPropagation( QWidget::NoChildren );
	RadioButton_MediumVcards->setPalettePropagation( QWidget::NoChildren );
	RadioButton_MediumVcards->setText( i18n("Display Medium Vcards" ));
	RadioButton_MediumVcards->setAutoRepeat( FALSE );
	RadioButton_MediumVcards->setAutoResize( FALSE );
	RadioButton_MediumVcards->setChecked( default_medium );

	RadioButton_CompleteVcards = new QRadioButton( this, "RadioButton_CompleteVcards" );
	RadioButton_CompleteVcards->setGeometry( 10, 230, 210, 30 );
	RadioButton_CompleteVcards->setMinimumSize( 0, 0 );
	RadioButton_CompleteVcards->setMaximumSize( 32767, 32767 );
	connect( RadioButton_CompleteVcards, SIGNAL(toggled(bool)), SLOT(slot_kpreferences_complete(bool)) );
	RadioButton_CompleteVcards->setFocusPolicy( QWidget::TabFocus );
	RadioButton_CompleteVcards->setBackgroundMode( QWidget::PaletteBackground );
	RadioButton_CompleteVcards->setFontPropagation( QWidget::NoChildren );
	RadioButton_CompleteVcards->setPalettePropagation( QWidget::NoChildren );
	RadioButton_CompleteVcards->setText( i18n("Display Complete Vcards" ));
	RadioButton_CompleteVcards->setAutoRepeat( FALSE );
	RadioButton_CompleteVcards->setAutoResize( FALSE );
	RadioButton_CompleteVcards->setChecked( default_complete );

	RadioButton_OverCompleteVcards = new QRadioButton( this, "RadioButton_OverCompleteVcards" );
	RadioButton_OverCompleteVcards->setGeometry( 10, 260, 210, 30 );
	RadioButton_OverCompleteVcards->setMinimumSize( 0, 0 );
	RadioButton_OverCompleteVcards->setMaximumSize( 32767, 32767 );
	connect( RadioButton_OverCompleteVcards, SIGNAL(toggled(bool)), SLOT(slot_kpreferences_overcomplete(bool)) );
	RadioButton_OverCompleteVcards->setFocusPolicy( QWidget::TabFocus );
	RadioButton_OverCompleteVcards->setBackgroundMode( QWidget::PaletteBackground );
	RadioButton_OverCompleteVcards->setFontPropagation( QWidget::NoChildren );
	RadioButton_OverCompleteVcards->setPalettePropagation( QWidget::NoChildren );
	RadioButton_OverCompleteVcards->setText( i18n("Display Over Complete Vcards" ));
	RadioButton_OverCompleteVcards->setAutoRepeat( FALSE );
	RadioButton_OverCompleteVcards->setAutoResize( FALSE );
	RadioButton_OverCompleteVcards->setChecked( default_overcomplete );

	Label_Date = new QLabel( this, "Label_Date" );
	Label_Date->setGeometry( 10, 290, 120, 30 );
	Label_Date->setMinimumSize( 0, 0 );
	Label_Date->setMaximumSize( 32767, 32767 );
	Label_Date->setFocusPolicy( QWidget::NoFocus );
	Label_Date->setBackgroundMode( QWidget::PaletteBackground );
	Label_Date->setFontPropagation( QWidget::NoChildren );
	Label_Date->setPalettePropagation( QWidget::NoChildren );
	Label_Date->setFrameStyle( 0 );
	Label_Date->setLineWidth( 1 );
	Label_Date->setMidLineWidth( 0 );
	Label_Date->QFrame::setMargin( 0 );
	Label_Date->setText( i18n("Display the Date in" ));
	Label_Date->setAlignment( 289 );
	Label_Date->setMargin( -1 );
			
	ComboBox_Date = new QComboBox( FALSE, this, "ComboBox_Date" );
	ComboBox_Date->setGeometry( 120, 290, 120, 30 );
	ComboBox_Date->setMinimumSize( 0, 0 );
	ComboBox_Date->setMaximumSize( 32767, 32767 );
//	connect( ComboBox_Date, SIGNAL(activated(const char*)), SLOT(slot_kpreferences_Date_activatedchar(const char*)) );
	connect( ComboBox_Date, SIGNAL(activated(int)), SLOT(slot_kpreferences_date_activatedint(int)) );
//	connect( ComboBox_Date, SIGNAL(highlighted(const char*)), SLOT(slot_kpreferences_Date_highlightedchar(const char*)) );
//	connect( ComboBox_Date, SIGNAL(highlighted(int)), SLOT(slot_kpreferences_Date_highlightedint(int)) );
	ComboBox_Date->setFocusPolicy( QWidget::StrongFocus );
	ComboBox_Date->setBackgroundMode( QWidget::PaletteBackground );
	ComboBox_Date->setFontPropagation( QWidget::AllChildren );
	ComboBox_Date->setPalettePropagation( QWidget::AllChildren );
	ComboBox_Date->setAutoResize( FALSE );
	ComboBox_Date->insertItem( i18n("Day/Month/Year" ));
	ComboBox_Date->insertItem( i18n("Month/Day/Year" ));
	ComboBox_Date->insertItem( i18n("Year/Day/Month" ));
	ComboBox_Date->insertItem( i18n("Year/Month/Day" ));
	ComboBox_Date->setMaxCount( 2147483647 );
	ComboBox_Date->setAutoCompletion( FALSE );
	ComboBox_Date->setSizeLimit( 3 );
	ComboBox_Date->setCurrentItem(default_date);


	PushButton_Ok = new QPushButton( this, "PushButton_Ok" );
	PushButton_Ok->setGeometry( 10, 340, 100, 30 );
	PushButton_Ok->setMinimumSize( 100, 30 );
	PushButton_Ok->setMaximumSize( 100, 30 );
	connect( PushButton_Ok, SIGNAL(clicked()), SLOT(slot_kpreferences_ok()) );
	PushButton_Ok->setFocusPolicy( QWidget::TabFocus );
	PushButton_Ok->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_Ok->setFontPropagation( QWidget::NoChildren );
	PushButton_Ok->setPalettePropagation( QWidget::NoChildren );
	PushButton_Ok->setText( i18n("OK" ));
	PushButton_Ok->setAutoRepeat( FALSE );
	PushButton_Ok->setAutoResize( FALSE );
	PushButton_Ok->setToggleButton( FALSE );
	PushButton_Ok->setDefault( FALSE );
	PushButton_Ok->setAutoDefault( FALSE );
	PushButton_Ok->setIsMenuButton( FALSE );

	PushButton_Cancel = new QPushButton( this, "PushButton_Cancel" );
	PushButton_Cancel->setGeometry( 140, 340, 100, 30 );
	PushButton_Cancel->setMinimumSize( 0, 0 );
	PushButton_Cancel->setMaximumSize( 32767, 32767 );
	connect( PushButton_Cancel, SIGNAL(clicked()), SLOT(slot_kpreferences_cancel()) );
	PushButton_Cancel->setFocusPolicy( QWidget::TabFocus );
	PushButton_Cancel->setBackgroundMode( QWidget::PaletteBackground );
	PushButton_Cancel->setFontPropagation( QWidget::NoChildren );
	PushButton_Cancel->setPalettePropagation( QWidget::NoChildren );
	PushButton_Cancel->setText( i18n("Cancel" ));
	PushButton_Cancel->setAutoRepeat( FALSE );
	PushButton_Cancel->setAutoResize( FALSE );
	PushButton_Cancel->setToggleButton( FALSE );
	PushButton_Cancel->setDefault( FALSE );
	PushButton_Cancel->setAutoDefault( FALSE );
	PushButton_Cancel->setIsMenuButton( FALSE );

	ButtonGroup_Preferences->insert( RadioButton_SmallVcards );
	ButtonGroup_Preferences->insert( RadioButton_MediumVcards );
	ButtonGroup_Preferences->insert( RadioButton_CompleteVcards );
	ButtonGroup_Preferences->insert( RadioButton_OverCompleteVcards );

autoloadaddressbook	=default_autoloadaddressbook;
autoexportkmail		=default_autoexportkmail;
autoexportkab		=default_autoexportkab;
autosaveonquit		=default_autosaveonquit;
vcardextensions		=default_vcardextensions;
small			=default_small;
medium			=default_medium;
complete		=default_complete;
overcomplete		=default_overcomplete;
date			=default_date;

	setToolTips();
	resize( 250,380 );
	setMinimumSize( 250, 380 );
	setMaximumSize( 250, 380 );
}


Preferences::~Preferences()
{
}

void Preferences::slot_kpreferences_autoloadaddressbook(bool this_bool)
{
autoloadaddressbook=this_bool;
}

void Preferences::slot_kpreferences_autoexportkmail(bool this_bool)
{
autoexportkmail=this_bool;
}

void Preferences::slot_kpreferences_autoexportkab(bool this_bool)
{
autoexportkab=this_bool;
}

void Preferences::slot_kpreferences_autosaveonquit(bool this_bool)
{
autosaveonquit=this_bool;
}

void Preferences::slot_kpreferences_vcarddirectory()
{
KDirDialog dialog(vcarddirectory,0,"dirdialog");
dialog.setCaption(i18n("Choose the Vcard Saving Directory"));
dialog.show();
vcarddirectory=dialog.selectedFile();
}

void Preferences::slot_kpreferences_vcardextensions(bool this_bool)
{
vcardextensions=this_bool;
}

void Preferences::slot_kpreferences_vcardextensionsdirectory()
{
KDirDialog dialog(vcardextensionsdirectory,0,"dirdialog");
dialog.setCaption(i18n("Choose the Vcard Extensions Saving Directory"));
dialog.show();
vcardextensionsdirectory=dialog.selectedFile();
}

void Preferences::slot_kpreferences_small(bool this_bool)
{
small=this_bool;
}

void Preferences::slot_kpreferences_medium(bool this_bool)
{
medium=this_bool;
}

void Preferences::slot_kpreferences_complete(bool this_bool)
{
complete=this_bool;
}

void Preferences::slot_kpreferences_overcomplete(bool this_bool)
{
overcomplete=this_bool;
}


void Preferences::slot_kpreferences_date_activatedint(int this_int)
{
date=this_int;
}


void Preferences::slot_kpreferences_ok()
{
write_preferences();

default_autoloadaddressbook	=autoloadaddressbook;
default_autoexportkmail		=autoexportkmail;
default_autoexportkab		=autoexportkab;
default_autosaveonquit		=autosaveonquit;
default_vcardextensions		=vcardextensions;
default_small			=small;
default_medium			=medium;
default_complete		=complete;
default_overcomplete		=overcomplete;
default_date			=date;

CheckBox_AutoLoadAddressBook->setChecked( default_autoloadaddressbook );
CheckBox_AutoExportKmail->setChecked( default_autoexportkmail );
CheckBox_AutoExportKab->setChecked( default_autoexportkab );
CheckBox_AutoSaveonQuit->setChecked( default_autosaveonquit );
CheckBox_VcardExtensions->setChecked( default_vcardextensions );
RadioButton_SmallVcards->setChecked( default_small );
RadioButton_MediumVcards->setChecked( default_medium );
RadioButton_CompleteVcards->setChecked( default_complete );
RadioButton_OverCompleteVcards->setChecked( default_overcomplete );
ComboBox_Date->setCurrentItem( default_date );

write_preferences();
config->sync();
this->hide();
}

void Preferences::slot_kpreferences_cancel()
{
autoloadaddressbook	=default_autoloadaddressbook;
autoexportkmail		=default_autoexportkmail;
autoexportkab		=default_autoexportkab;
autosaveonquit		=default_autosaveonquit;
vcardextensions		=default_vcardextensions;
small			=default_small;
medium			=default_medium;
complete		=default_complete;
overcomplete		=default_overcomplete;
date			=default_date;

CheckBox_AutoLoadAddressBook->setChecked( default_autoloadaddressbook );
CheckBox_AutoExportKmail->setChecked( default_autoexportkmail );
CheckBox_AutoExportKab->setChecked( default_autoexportkab );
CheckBox_AutoSaveonQuit->setChecked( default_autosaveonquit );
CheckBox_VcardExtensions->setChecked( default_vcardextensions );
RadioButton_SmallVcards->setChecked( default_small );
RadioButton_MediumVcards->setChecked( default_medium );
RadioButton_CompleteVcards->setChecked( default_complete );
RadioButton_OverCompleteVcards->setChecked( default_overcomplete );
ComboBox_Date->setCurrentItem( default_date );

write_preferences();
config->sync();
this->hide();
}

void Preferences::closeEvent(QCloseEvent *e)
{
slot_kpreferences_cancel();
}

void Preferences::read_preferences()
{
	QString preference_lue;
	QString tempprinter;
	//General Preferences
	config->setGroup("General Preferences");

	preference_lue = config->readEntry("AutoLoadAddressBook","");
	if (preference_lue.isEmpty())
		{
		QString Warning;
		Warning =i18n("Congratulations and Thanks for using kvcard.\n");
		Warning+=i18n("Please let me known it so that i work on it\n");
		Warning+=i18n("on a regular basis to improve it and correct bugs.\n\n");
		KMsgBox::message(0,i18n("This is the first time you use kvcard!"),Warning,4);
		config->writeEntry("AutoLoadAddressBook","TRUE");
		default_autoloadaddressbook=TRUE;
		}
	else
		{
		default_autoloadaddressbook=convert_read(preference_lue);
		}
		
	preference_lue = config->readEntry("AutoExportKmail","");
	if (preference_lue.isEmpty())
		{
		config->writeEntry("AutoExportKmail","FALSE");
		default_autoexportkmail=FALSE;
		}
	else
		{
		default_autoexportkmail=convert_read(preference_lue);
		}
	
	preference_lue = config->readEntry("AutoExportKab","");
	if (preference_lue.isEmpty())
		{
		config->writeEntry("AutoExportKab","FALSE");
		default_autoexportkab=FALSE;
		}
	else
		{
		default_autoexportkab=convert_read(preference_lue);
		}
	
	preference_lue = config->readEntry("AutoSaveOnQuit","");
	if (preference_lue.isEmpty())
		{
		config->writeEntry("AutoSaveOnQuit","TRUE");
		default_autosaveonquit=TRUE;
		}
	else
		{
		default_autosaveonquit=convert_read(preference_lue);
		}
	
	preference_lue = config->readEntry("DisplayExtensions","");
	if (preference_lue.isEmpty())
		{
		config->writeEntry("DisplayExtensions","FALSE");
		default_vcardextensions=FALSE;
		}
	else
		{
		default_vcardextensions=convert_read(preference_lue);
		}
	
	preference_lue = config->readEntry("SizeOfCards","");
	if (preference_lue.isEmpty())
		{
   		config->writeEntry("SizeOfCard","small");
		default_small=TRUE;
		default_medium=FALSE;
		default_complete=FALSE;
		default_overcomplete=FALSE;
		}
	else
		{
		if (preference_lue== QString("small"))
			{
			default_small=TRUE;
			default_medium=FALSE;
			default_complete=FALSE;
			default_overcomplete=FALSE;
			}
		else
			{
			if (preference_lue== QString("medium"))
				{
				default_small=FALSE;
				default_medium=TRUE;
				default_complete=FALSE;
				default_overcomplete=FALSE;
				}
			else
				{
				if (preference_lue== QString("complete"))
					{
					default_small=FALSE;
					default_medium=FALSE;
					default_complete=TRUE;
					default_overcomplete=TRUE;
				 	}
				else
					{
					if (preference_lue== QString("overcomplete"))
						{
						default_small=FALSE;
						default_medium=FALSE;
						default_complete=FALSE;
						default_overcomplete=TRUE;
						}
					else
						{
						default_small=TRUE;
						default_medium=FALSE;
						default_complete=FALSE;
						default_overcomplete=FALSE;
						}
					}
				}
			}
		}
	preference_lue=config->readEntry("DisplayDate","");
	if (preference_lue.isEmpty())
		{
   		config->writeEntry("DisplayDate","Day/Month/Year");
   		default_date=0;
   		}
   	else
   		{
   		if (preference_lue==QString("Day/Month/Year"))
   			{
   			default_date=0;
   			}
		else
			{
   			if (preference_lue==QString("Month/Day/Year"))
   				{
   				default_date=1;
   				}
			else
				{
   				if (preference_lue==QString("Year/Day/Month"))
   					{
   					default_date=2;
   					}
				else
					{
					if (preference_lue==QString("Year/Month/Day"))
						{
						default_date=3;
   						}
					else
						{
						default_date=0;
						}
					}
				}
			}
		}   		
	//Directories
	config->setGroup("Directories");
	preference_lue = config->readEntry("Vcard Directory","");
	if (preference_lue.isEmpty())
		{
		vcarddirectory=getenv("HOME");
   		config->writeEntry("Vcard Directory",vcarddirectory);
		}
	else
		{
		vcarddirectory=preference_lue;
		}

	preference_lue = config->readEntry("Vcard Extensions Directory","");
	if (preference_lue.isEmpty())
		{
		vcardextensionsdirectory=getenv("HOME");
   		config->writeEntry("Vcard Directory",vcardextensionsdirectory);
		}
	else
		{
		vcardextensionsdirectory=preference_lue;
		}
}

void Preferences::write_preferences()
{
QString temp;
config->setGroup("General Preferences");

if (autoloadaddressbook==TRUE) temp = QString ("TRUE");
if (autoloadaddressbook==FALSE) temp = QString ("FALSE");
config->writeEntry("AutoLoadAddressBook",temp);

if (autoexportkmail==TRUE) temp = QString ("TRUE");
if (autoexportkmail==FALSE) temp = QString ("FALSE");
config->writeEntry("AutoExportKmail",temp);

if (autoexportkab==TRUE) temp = QString ("TRUE");
if (autoexportkab==FALSE) temp = QString ("FALSE");
config->writeEntry("AutoExportKab",temp);

if (autosaveonquit==TRUE) temp = QString ("TRUE");
if (autosaveonquit==FALSE) temp = QString ("FALSE");
config->writeEntry("AutoSaveOnQuit",temp);

if (vcardextensions==TRUE) temp = QString ("TRUE");
if (vcardextensions==FALSE) temp = QString ("FALSE");
config->writeEntry("DisplayExtensions",temp);

if (small==TRUE) config->writeEntry("SizeOfCards","small");
if (medium==TRUE) config->writeEntry("SizeOfCards","medium");
if (complete==TRUE) config->writeEntry("SizeOfCards","complete");
if (overcomplete==TRUE) config->writeEntry("SizeOfCards","overcomplete");

if (date==0) config->writeEntry("DisplayDate", "Day/Month/Year" );
if (date==1) config->writeEntry("DisplayDate", "Month/Day/Year" );
if (date==2) config->writeEntry("DisplayDate", "Year/Day/Month" );
if (date==3) config->writeEntry("DisplayDate", "Year/Month/Day" );

config->setGroup("Directories");

config->writeEntry("Vcard Directory",vcarddirectory);
config->writeEntry("Vcard Extensions Directory",vcardextensionsdirectory);
config->sync();
}

bool Preferences::convert_read(QString this_QString)
{
	if ((this_QString==QString("false"))||(this_QString==QString("FALSE"))) return (FALSE);
	if ((this_QString==QString("true"))||(this_QString==QString("TRUE"))) return (TRUE);
}

void Preferences::setToolTips()
{
QToolTip::add(CheckBox_AutoLoadAddressBook,
i18n("If checked, the default addressbook\nwill automatically be loaded each time\nyou start the program"));

QToolTip::add(CheckBox_AutoExportKmail,
i18n("If checked, the addressbook will\nautomatically be exported to kmail"));

QToolTip::add(CheckBox_AutoExportKab,
i18n("If checked, the addressbook will\nautomatically be exported to kab"));

QToolTip::add(CheckBox_AutoSaveonQuit,
i18n("If checked, the addressbook will\nautomatically be saved on quit"));

QToolTip::add(PushButton_VcardDirectory,
i18n("Choose the directory in which\nyour cards will be saved"));

QToolTip::add(CheckBox_VcardExtensions,
i18n("If checked, the cards will\nbe displayed with their\nmultimedia extensions"));

QToolTip::add(PushButton_VcardExtensionsDirectory,
i18n("Choose the directory in which\nyour cards extensions are saved"));

QToolTip::add(RadioButton_SmallVcards,
i18n("If checked, your cards will\ndisplay only name, home phone\nand personal e-mail"));

QToolTip::add(RadioButton_MediumVcards,
i18n("If checked, your cards will\ndisplay name, address, phones\npersonnal and company e-mails"));

QToolTip::add(RadioButton_CompleteVcards,
i18n("If checked, your cards will\ndisplay all the informations\nfields you included"));

QToolTip::add(RadioButton_OverCompleteVcards,
i18n("If checked, your cards will\ndisplay tremendous informations\nsuch as the type, character-set\nlanguage used for each field\nand accept all type of options"));

QToolTip::add(ComboBox_Date,
i18n("Choose the way the date will be displayed"));

QToolTip::add(PushButton_Ok,
i18n("Validate your preferences modifications"));

QToolTip::add(PushButton_Cancel,
i18n("Discard your preferences modifications"));

}
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
