/**************************************************************************
 * $Id: GraphOptions.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef GraphOptions_included
#define GraphOptions_included

#include "dlg/GraphOptionsData.h"
#include <SamplinPlot.h>
#include "GraphGrid.h"
#include "GraphLayout.h"
#include "GraphLegend.h"

class GraphOptions : public GraphOptionsData
{
    Q_OBJECT

public:

    GraphOptions
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

   virtual ~GraphOptions();
   void setData(SamplinPlot *);
   
 protected slots:
   virtual void apply();
   virtual void ok();
   virtual void cancel();
   
 protected:
   SamplinPlot *series;
   GraphGrid *dgrid;
   GraphLayout *dlayout;
   GraphLegend *dlegend;
   
 signals:
   void update();
};
#endif // GraphOptions_included
