/**************************************************************************
 * $Id: GraphPanel.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef GraphPanel_included
#define GraphPanel_included

#include <SamplinPlot.h>

#include "GraphOptions.h"
#include "Graph_axis.h"
#include "Graph_series.h"
#include "PropBox.h"

#include <kpopmenu.h>
#include <kiconloader.h>
#include <ktreelist.h>

extern SamplinCurve *clipboard_curve;

class PropItem : public PropBoxItem
{
 public:
   PropItem( const char *s, const QPixmap *p, uint key=0, int obj=-1 )
     : PropBoxItem()
     { setText( s ); d_key=key; pm=p; d_obj=obj;}
   PropItem( const char *s, const QPixmap &p, uint key=0, int obj=-1 )
     : PropBoxItem() , pix(p)
     { setText( s ); d_key=key; pm=&pix; d_obj=obj; }
   uint key(){return(d_key);}
   void setKey(uint k){d_key=k;};
   int object(){return(d_obj);}
   void setObject(int o){d_obj=o;};
 protected:
   virtual void paint( QPainter * );
   virtual int height( const PropBox * ) const;
   virtual int width( const PropBox * ) const;
   virtual const QPixmap *pixmap() { return pm; }
   
 private:
   const QPixmap *pm;
   QPixmap pix;
   uint d_key;
   int d_obj;
   friend class GraphPropBox;
};


class GraphPropBox : public PropBox
{
   Q_OBJECT
 public:
   GraphPropBox( QWidget *parent=0, const char *name=0, WFlags f=0 )
     : PropBox(parent,name,f){};

   int object(int index);
   uint currentKey(void);
};


class GraphPanel : public QFrame
{
    Q_OBJECT

 protected:
   void  resizeEvent( QResizeEvent * );
   void paintEvent( QPaintEvent * );
   void listFill(bool repaint=TRUE);
   SamplinCurve *currentCurve();
   QString selectFile(const char *caption, const char *ext);
   
   int show_list;
   int current_object;
   
   SamplinPlot *graph;   
   KPopupMenu *popgraph, *popseries, *popxbaxis, *popxtaxis, *popyraxis, *popylaxis, *popexport;
   KPath *spath;
 public:

    GraphPanel
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~GraphPanel();

   bool load(const char *fn);
   bool save(const char *fn);
   bool export(const char *fn);
   bool exportData(const char *fn);
   bool exportPic(const char *fn);
   bool exportBMP(const char *fn);
   bool loadTempl(const char *fn);
   bool saveTempl(const char *fn);
   
   bool loadDlg(const char *fn);
   bool saveDlg(const char *fn);
   
   bool insertCurve(uint key, const char *n, int xAxis = xBottom, int yAxis = yLeft ){
      bool ret;
      ret=graph->insertCurve(key,n,xAxis,yAxis);
      listFill();
      return ret;
   }
   uint insertCurve(const char *n, int xAxis = xBottom, int yAxis = yLeft){
      uint ret;
      ret=graph->insertCurve(n,xAxis,yAxis);
      listFill();
      return ret;
   }
   bool removeCurve(uint key){
      bool ret;
      ret=graph->removeCurve(key);      
      listFill(key);
      return ret;
   }
   void mapCurve(uint key, int axis){
      graph->mapCurve(key,axis);
   }
   bool setCurveRawData(uint key, double *x, double *y, int size){
      return graph->setCurveRawData(key,x,y,size);
   }
   bool setCurveRawData(uint key, double begin, double step, double *y, int size){
      return graph->setCurveRawData(key,begin,step,y,size);
   }
   bool setCurveRawData(uint key, double *x, double begin, double step, int size){
      return graph->setCurveRawData(key,x,begin,step,size);
   }
   bool setCurveData(uint key, double *x, double *y, int size){
      return graph->setCurveData(key,x,y,size);
   }
   bool setCurveData(uint key, double begin, double step, double *y, int size){
      return graph->setCurveData(key,begin,step,y,size);
   }
   bool setCurveData(uint key, double *x, double begin, double step, int size){
      return graph->setCurveData(key,x,begin,step,size);      
   }
   bool setCurveStyle(uint key, SamplinCurveData::CurveStyle s){
      return graph->setCurveStyle(key,s);
   }
   bool setCurvePen(uint key, const QPen &pen){
      return graph->setCurvePen(key, pen);
   }
   bool setCurveSymbol(uint key, const QwtSymbol &s){
      return graph->setCurveSymbol(key,s);
   }
   bool setCurveSplineType(uint key, int t){
      return graph->setCurveSplineType(key,t);
   }
   bool setCurveSplineSize(uint key, int s){
      return graph->setCurveSplineSize(key,s);
   }
   QString curveName(uint key){
      return graph->curveName(key);
   }
   uint curveKey(const char *n){
      return graph->curveKey(n);
   }
   virtual SamplinCurve *findCurve(uint key){
      return graph->findCurve(key);
   }

   const char   *fileName( void ){
      return graph->fileName();
   }
   bool isSaved(void){
      return graph->isSaved();
   }
   void setLabel(const char *str){
      graph->setLabel(str);
   }
   const char *label(void){
      return graph->label();
   }
   void setPlotColor(const QColor &c){
      graph->setPlotColor(c);
   }
   void setPanelColor(const QColor &c){
      graph->setPanelColor(c);
   }
   void setLegendPosition(char pos){
      graph->setLegendPosition(pos);
   }
   void setCommentPosition(char pos){
      graph->setCommentPosition(pos);
   }
   void setTitle(const char *t){
      graph->setTitle(t);
   }
   void setAxisTitle(int axis, const char *t){
      graph->setAxisTitle(axis, t);
   }

   SamplinScaleBox *axis(int axis){
      return graph->axis(axis);
   }
   
   void setComment(const char *str){
      graph->setComment(str);
   }
   const char *comment(void){
      return graph->comment();
   }
 protected:

   GraphPropBox *list;
   QPushButton *handlebutton;
   GraphOptions *groptions;
   Graph_axis *graxis;
   Graph_series *grseries;
   
 protected slots:
   virtual void handleClick();
   void listPopup(QMouseEvent *e, int);
   void listHighlight(int);
   void graphClick(const QMouseEvent *m,int object, uint key);
   void graphDoubleClick(const QMouseEvent *m,int object, uint key);   
 
 public slots:
   void replot();
   bool load();
   bool save();
   bool saveAs();
   bool exportData();
   bool exportPic();
   bool exportBMP();
   void print();

   bool loadTempl();
   bool saveTempl();
   
   void editCut();
   void editCopy();   
   void editPaste();
   void editRename();

   void propTop();
   void propBottom();
   void propCurrent();
   void propGraph();
   void propSeries();
   void propAxes(int axis);

   void propXBAxis();
   void propXTAxis();
   void propYLAxis();
   void propYRAxis();
   
   void objectProperties(int);
   void objectPopup(QPoint &pt, int obj);
   
   void selectObject(int,uint);   
 signals:
   void pointShow(int,float,float);
   void objectChange(int, uint);
};
#endif // GraphPanel_included

