/**************************************************************************
 * $Id: SamplinGrid.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3 beta $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "SamplinGrid.h"

//------------------------------------------------------------
//
//.S	SamplinGrid::SamplinGrid
//	Construct a SamplinGrid instance
//
//.s	Description
//
//.s	Syntax
//.f	 SamplinGrid::SamplinGrid()
//
//------------------------------------------------------------
SamplinGrid::SamplinGrid()
: d_majPen(gray,1, DotLine), d_minPen(gray, 1, DotLine)
{
    d_xMinEnabled = false;
    d_yMinEnabled = false;
    d_xEnabled = true;
    d_yEnabled = true;
   d_majPen=QPen(black,0,DotLine);
   d_minPen=QPen(black,0,DotLine);
}

//------------------------------------------------------------
//
//.S	SamplinGrid::~SamplinGrid
//	Destroy a SamplinGrid instance
//
//.s	Syntax
//.f	 SamplinGrid::~SamplinGrid()
//
//------------------------------------------------------------
SamplinGrid::~SamplinGrid()
{
    
}

//------------------------------------------------------------
//
//.S	SamplinGrid::enableX
//	Enable or disable x axis grid lines
//
//.s	Parameters
//.p	bool tf -- true or false
//
//.s	Syntax
//.f	void SamplinGrid::enableX(bool tf)
//
//------------------------------------------------------------
void SamplinGrid::enableX(bool tf)
{
    d_xEnabled = tf;
}

//------------------------------------------------------------
//
//.S	SamplinGrid::enableY
//	Enable or disable y axis gridlines
//
//.s	Syntax
//.f	void SamplinGrid::enableY(bool tf)
//
//------------------------------------------------------------
void SamplinGrid::enableY(bool tf)
{
  d_yEnabled = tf;  
}

//------------------------------------------------------------
//
//.S	SamplinGrid::enableXMin
//	Enable or disable minor divisions of the x axis
//
//.s	Parameters
//.p	bool tf -- true or false
//
//.s	Description
//
//.s	Syntax
//.f	void SamplinGrid::tfXMin(bool tf)
//
//------------------------------------------------------------
void SamplinGrid::enableXMin(bool tf)
{
    d_xMinEnabled = tf;
}

//------------------------------------------------------------
//
//.S	SamplinGrid::enableYMin
//	enable or disable minor divisions of the y axis
//
//.s	Parameters
//.p	bool tf
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void SamplinGrid::enableYMin(bool tf)
//
//------------------------------------------------------------
void SamplinGrid::enableYMin(bool tf)
{
    d_yMinEnabled = tf;
}

//------------------------------------------------------------
//
//.S	SamplinGrid::setXDiv
//	Assign x axis scale division
//
//.s	Parameters
//.p	const QwtScaleDiv &sx -- scale division
//
//.s	Note
//	SamplinGrid uses implicit sharing (see Qt Manual) for
//	the scale divisions.
//
//.s	Syntax
//.f	void SamplinGrid::setXDiv(const QwtScaleDiv &sx)
//
//------------------------------------------------------------
void SamplinGrid::setXDiv(const QwtScaleDiv &sx)
{
    d_sdx = sx;
}

//------------------------------------------------------------
//
//.S	SamplinGrid::setYDiv
//	Assign y axis division
//
//.s	Parameters
//.p	const QwtScaleDiv &sy -- scale division
//
//.s	Note
//	SamplinGrid uses implicit sharing (see Qt Manual) for
//	the scale divisions.
//
//.s	Syntax
//.f	void SamplinGrid::setYDiv(const QwtScaleDiv &sy)
//
//------------------------------------------------------------
void SamplinGrid::setYDiv(const QwtScaleDiv &sy)
{
	d_sdy = sy;    
}

//------------------------------------------------------------
//
//.S	SamplinGrid::setPen
//	Assign a pen for both major and minor gridlines
//
//.s	Parameters
//.p	const QPen &p -- pen
//
//.s	Syntax
//.f	void SamplinGrid::setPen(const QPen &p)
//
//------------------------------------------------------------
void SamplinGrid::setPen(const QPen &p)
{
    d_majPen = p;
    d_minPen = p;
}

//------------------------------------------------------------
//
//.S	SamplinGrid::setMajPen
//	Assign a pen for the major gridlines
//
//.s	Syntax
//.f	void SamplinGrid::setMajPen(const QPen &p)
//
//------------------------------------------------------------
void SamplinGrid::setMajPen(const QPen &p)
{
    d_majPen = p;
}

//------------------------------------------------------------
//
//.S	SamplinGrid:.setMinPen
//	Assign a pen for the minor gridlines
//
//.s	Syntax
//.f	void SamplinGrid:.setMinPen(const QPen &p)
//
//------------------------------------------------------------
void SamplinGrid::setMinPen(const QPen &p)
{
  d_minPen = p;  
}

//------------------------------------------------------------
//
//.S	SamplinGrid::draw
//	Draw the grid
//
//.s	Parameters
//.p	QPainter *p -- Qt painter
//	const QwtDiMap &mx -- x axis map
//	const QwtDiMap &my -- y axis map
//
//.s	Description
//
//.s	Syntax
//.f	void SamplinGrid::draw(QPainter *p, const QwtDiMap &mx, const QwtDiMap &my)
//
//------------------------------------------------------------
void SamplinGrid::draw(QPainter *p, const QRect &r, const QwtDiMap &mx, const QwtDiMap &my)
{

   int i, x = 0, y = 0;
   int x1, x2, y1, y2,x0,y0;
   x0 = 0;//r.left();
   x2 = r.right();
   x1 = r.left();
   y0= 0;//r.top();
   y1= r.top();
   y2 = r.bottom();

    //
    //  draw minor gridlines
    //
    p->setPen(d_minPen);
    
    if (d_xEnabled && d_xMinEnabled)
    {
	for (i=0;i<d_sdx.minCnt();i++)
	{
	    x = mx.transform(d_sdx.minMark(i));
	    if ((x >= x1) && (x <= x2))
	        p->drawLine(x0+x, y0+y1, x0+x, y0+y2);
	}
	
    }

    if (d_yEnabled && d_yMinEnabled)
    {
	for (i=0;i<d_sdy.minCnt();i++)
	{
	    y = my.transform(d_sdy.minMark(i));
	    if ((y >= y1) && (y <= y2))
	        p->drawLine(x0+x1, y0+y, x0+x2, y0+y);
	}
	
    }

    //
    //  draw major gridlines
    //
    p->setPen(d_majPen);
    
    if (d_xEnabled)
    {
	for (i=0;i<d_sdx.majCnt();i++)
	{
	   x = mx.transform(d_sdx.majMark(i));
	    p->drawLine(x0+x, y0+y1, x0+x, y0+y2);
	}
       
    }
    
    if (d_yEnabled)
    {
	for (i=0;i<d_sdy.majCnt();i++)
	{
	    y = my.transform(d_sdy.majMark(i));
	    p->drawLine(x0+x1, y0+y, x0+x2, y0+y);
	}
    }
    
}

QDataStream &operator<<( QDataStream &s, const SamplinGrid &grid )
{
   char b;
   
   b=grid.xEnabled();
   s << b;
   b=grid.yEnabled();
   s << b;
   b=grid.xMinEnabled();
   s << b;
   b=grid.yMinEnabled();
   s << b;
   s << grid.xAxis();
   s << grid.yAxis();
   s << grid.majPen();
   s << grid.minPen();
   
   return(s);
}


QDataStream &operator>>( QDataStream &s, SamplinGrid &grid )
{
   char e;
   int i;
   QPen pen;
   
   s >> e;
   grid.enableX(e);
   s >> e;
   grid.enableY(e);
   s >> e;
   grid.enableXMin(e);
   s >> e;
   grid.enableYMin(e);
   s >> i;
   grid.setXAxis(i);
   s >> i;
   grid.setYAxis(i);
   s >> pen;
   grid.setMajPen(pen);
   s >> pen;
   grid.setMinPen(pen);
   return(s);
}
