/**************************************************************************
 * $Id: SamplinEdit.h 1.2 Thu, 18 Feb 1999 16:48:37 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef SamplinEdit_included
#define SamplinEdit_included
#include <keditcl.h>
#include <qlist.h>
#include <samplin.h>

//extern struct configstruct cnf;

class LineItem
{
 public:
   LineItem(void){
      d_color=QColor(red);
      d_line=0;
   };
   LineItem(int line, QColor &color);
   virtual ~LineItem();
   
   void setColor(QColor &c){d_color=c;
   }
   void setPalette(QPalette &p){d_pal=p;
   }
   void setLine(int l){d_line=l;
   }
   const QColor &color(void){return d_color;
   }
   const QPalette &palette(void){return d_pal;
   }
   int line(void){return d_line;
   }


   
 protected:
   QPalette d_pal;
   QColor d_color;
   int d_line;
   
};

class SamplinEdit : public KEdit
{
    Q_OBJECT

 public:
    SamplinEdit
    (
     class KApplication *app,
     QWidget* parent = NULL,
     const char* name = NULL
    );

    ~SamplinEdit();

   void addMarkedLine(int line,QColor &color);
   void delMarkedLine(int line);
   void delMarkedLines(void);
   void markLine(int line, const QColor &color=red);
   virtual void setFont(const QFont &){};
   virtual void mySetFont(const QFont &f){KEdit::setFont(f);};
   int newFile ();
   int doSave ();
   int saveAs ();
   int openFile ( int mode );
   int insertFile ();
   QString selectFile(const char *caption);
   
 protected:
   void paintCell(QPainter *, int row, int col);
   virtual void keyPressEvent ( QKeyEvent * );
   virtual void paletteChange ( const QPalette & oldPalette );
   QPalette &getPalette(QColor &);
   QPalette mypal,markpal;
   bool set_pal;
   QList<LineItem> d_lines;
   int marked_line;
   QColor marked_color;
   
   signals:
   void keyPressed();
};
#endif // SamplinEdit_included

