/* Reads NMOSTRES samples from argv[2] in DMA mode */

#define NMOSTRES 1000
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "pcl.h"              
              

int main(int argc, char **argv)
{

 int fd;
 short int byte[NMOSTRES];
 int count;
 short int timer=0,timer2=0;
 char signe=0;
 float dada;
 
 
 if(argc<2) 
 	{ 
 	 perror("Missing parameter (/dev/adc?)\n");
 	 exit(-1);
 	}

 if(!(fd=open(argv[1],O_RDONLY)))
  {
  	printf("Error opening %s",argv[1]);
  	exit(-1);
  }

 ioctl(fd,PCL_SET_GAIN,0);
 ioctl(fd,PCL_SET_MODE_CONTROL,PCL_SET_MODE_DMA); 
 

 
 ioctl(fd,PCL_SET_TIMER_CONTROL,PCL_COUNTER2|PCL_COUNTER_SQUARE_WAVE);
 ioctl(fd,PCL_SET_TIMER_CONTROL,PCL_COUNTER1|PCL_COUNTER_SQUARE_WAVE);
 

 ioctl(fd,PCL_SET_COUNTER2,20);
 ioctl(fd,PCL_SET_COUNTER1,10);
 
 if(read(fd,byte,NMOSTRES*2)!=NMOSTRES*2)
 	{
  	printf("Error al llegir %s",argv[1]);
  	exit(-1);
  	}


 close(fd);
 
 for(count=0;count<NMOSTRES;count++)
 {
  dada=(float)byte[count];
   
  dada=-10+20*dada/4096;

  printf(" %f\n", dada); 
 }
  
 exit(0);
}
