/**************************************************************************
 * $Id: GraphLayout.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "GraphLayout.h"
#include <kfontdialog.h>
#include <stdlib.h>

#include "GraphLayout.moc"

#define Inherited GraphLayoutData

GraphLayout::GraphLayout
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Graph options" );
}


GraphLayout::~GraphLayout()
{
}

void GraphLayout::setData(SamplinPlot *data)
{
   QString s;
   
   series=data;
   if(series!=NULL){
      d_title=data->title();
      d_font=data->titleFont();
      d_nfont=d_font;
      d_tcolor=data->titleColor();
      d_bcolor=data->panelColor();
      d_pcolor=data->plotColor();
      d_printfit=data->printFit();
      d_printinfo=data->printInfo();
      d_printwidth=data->printWidth();
      d_printheight=data->printHeight();
      d_stack=data->stacked();
      d_stackx=data->stackX();
      d_stacky=data->stackY();
      
      inp_title->setText(d_title);
      inp_tcolor->setColor(d_tcolor);
      inp_pcolor->setColor(d_pcolor);
      inp_bcolor->setColor(d_bcolor);
      
      s.sprintf("%i",d_printwidth);
      inp_width->setText(s);
      s.sprintf("%i",d_printheight);
      inp_height->setText(s);
      inp_fit->setChecked(d_printfit);
      inp_info->setChecked(d_printinfo);

      inp_stack->setChecked(d_stack);
      s.sprintf("%g",d_stackx);
      inp_stackx->setText(s);
      s.sprintf("%g",d_stacky);
      inp_stacky->setText(s);
      
   }
   
}

void GraphLayout::loadOld()
{
   if(series!=NULL){
      series->setTitle(d_title);
      series->setTitleFont(d_font);
      series->setTitleColor(d_tcolor);
      series->setPanelColor(d_bcolor);
      series->setPlotColor(d_pcolor);
      series->setPrintFit(d_printfit);
      series->setPrintInfo(d_printinfo);
      series->setPrintWidth(d_printwidth);
      series->setPrintHeight(d_printheight);

      series->setStacked(d_stack);
      series->setStackXY(d_stackx,d_stacky);
   }
}

void GraphLayout::selectFont()
{
   KFontDialog *fdlg;
   
   fdlg = new KFontDialog(this,"Select font",TRUE);
   fdlg->setFont(d_nfont);
   fdlg->show();
   if(fdlg->result()==QDialog::Accepted)
     d_nfont=fdlg->font();
   
   delete fdlg;
}

void GraphLayout::loadBack(void)
{
   QPen pen;
   int tmp;
   
   if(series!=NULL){
      
      series->setTitle(inp_title->text());
      series->setTitleColor(inp_tcolor->color());
      series->setTitleFont(d_nfont);
      series->setPlotColor(inp_pcolor->color());
      series->setPanelColor(inp_bcolor->color());
      
      series->setPrintWidth(atoi(inp_width->text()));
      series->setPrintHeight(atoi(inp_height->text()));
      series->setPrintFit(inp_fit->isChecked());
      series->setPrintInfo(inp_info->isChecked());

      series->setStacked(inp_stack->isChecked());
      series->setStackXY(atof(inp_stackx->text()),atof(inp_stacky->text()));
   }
   
}
