/**************************************************************************
 * $Id: SamplinPlotData.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef SampLin_Plot_Data_included
#define SampLin_Plot_Data_included

//#include <samplin.h>
#include <SamplinCurve.h>
#include <SamplinGrid.h>
#include <SamplinScaleBox.h>
#include <qintdict.h>
#include <qlist.h>
#include <qintdict.h>
#include <qbuffer.h>
#include <qfont.h>
#include <qfile.h>
#include <qdstream.h>
#include <qtextstream.h>
#include <qwt.h>


class SamplinPlotData
{

   friend class SamplinPlot;
   
 public:
   enum LegendPosition {None, Bottom, Right};
   
   SamplinPlotData();
   SamplinPlotData( const char *lbl);
   virtual ~SamplinPlotData();

   void init(void);


   //file operations
   virtual void setFileName(const char *str);
   const char *fileName( void ) const { return(filename);}
   
   void sendData(QDataStream &s);
   void receiveData(QDataStream &s);
   virtual bool load(const char *fn);
   void oldload(QDataStream &);
   void oldload2(QDataStream &);
   virtual bool save(const char *fn);
   virtual bool exportASCII(const char *fn);
   virtual bool importASCII(const char *fn);
   virtual bool loadTempl(const char *fn);
   virtual bool saveTempl(const char *fn);   
   void setSaved(void);
   bool isSaved(void);
   void setFileId(const char *s){d_fileid=s;}
   const char *fileError(void)const {return(d_fileerror);}
   
   //common functions

   void   setLabel( const char *str ){ d_label=str;}
   const char   *label( void ){ return(d_label); }
   void   setComment( const char *str ){ d_comment=str;}
   const char   *comment( void ){ return(d_comment); }
   virtual void setTitle(const char *t);
   const char   *title( void ){ return(d_title); }
   virtual void setTitleColor(const QColor &c);
   const QColor &titleColor(void){return d_titleColor;}
   virtual void setCommentColor(const QColor &c);
   const QColor &commentColor(void){return d_cColor;}
   virtual void setLegendColor(const QColor &c);
   const QColor &legendColor(void){return d_lColor;}
   virtual void setTitleFont(const QFont &f);
   const QFont &titleFont(void){return d_titleFont;}   
   virtual void setLegendFont(const QFont &f);
   const QFont &legendFont(void){return d_lFont;}   
   virtual void setCommentFont(const QFont &f);
   const QFont &commentFont(void){return d_cFont;}   
   
   virtual void setCommentPosition(char pos);
   const char commentPosition(void){return d_cpos;}   
   virtual void setLegendPosition(char pos);
   const char &legendPosition(void){return d_lpos;}   
   
   virtual void setPlotColor(const QColor &c){
      d_plotColor=c;
      autoRefresh();
   }
   const QColor &plotColor(void){return d_plotColor;}
   virtual void setPanelColor(const QColor &c){
      d_panelColor=c;
      autoRefresh();
   }
   const QColor &panelColor(void){return d_panelColor;}   
   
   void setPrintFit(bool a){d_printfit=a;
   }
   void setPrintInfo(bool a){d_printinfo=a;
   }
   bool printFit(void){return(d_printfit);
   }
   bool printInfo(void){return(d_printinfo);
   }
   void setPrintWidth(int a){d_printwidth=a;
   }
   int printWidth(void){return(d_printwidth);
   }
   void setPrintHeight(int a){d_printheight=a;
   }
   int printHeight(void){return(d_printheight);
   }   

   bool stacked(void){return d_stack;}
   void setStacked(bool stack){
      d_stack=stack;
      autoRefresh();
   }
   double stackX(void){return d_stackx;}
   double stackY(void){return d_stacky;}
   void setStackXY(double x, double y){
      d_stackx=x;
      d_stacky=y;
      autoRefresh();
   }
   
   //static members
   
   static int axis(const char *);
   static int lposition(const char *);
   
   //curves

   uint newCurveKey();
   virtual bool insertCurve(uint key, const char *name, int xAxis = xBottom, int yAxis = yLeft );
   virtual uint insertCurve(const char *name, int xAxis = xBottom, int yAxis = yLeft);
   virtual uint insertCurve(SamplinCurve *curve);
   virtual bool removeCurve(uint key);
   virtual void removeCurves();
   virtual void mapCurve(uint key, int axis);

   virtual bool setCurveRawData(uint key, double *x, double *y, int size);
   virtual bool setCurveRawData(uint key, double begin, double step, double *y, int size);
   virtual bool setCurveRawData(uint key, double *x, double begin, double step, int size);   
   virtual bool setCurveData(uint key, double *x, double *y, int size);
   virtual bool setCurveData(uint key, double begin, double step, double *y, int size);
   virtual bool setCurveData(uint key, double *x, double begin, double step, int size);   

   virtual bool setCurveStyle(uint key, SamplinCurve::CurveStyle s);
   virtual bool setCurvePen(uint key, const QPen &pen);
   virtual bool setCurveSymbol(uint key, const QwtSymbol &s);
   virtual bool setCurveSplineType(uint key, int t);
   virtual bool setCurveSplineSize(uint key, int s);

   virtual SamplinCurve::CurveStyle curveStyle(uint key);
   virtual const QwtSymbol &curveSymbol(uint key);
   virtual const QPen &curvePen(uint key);
   virtual int curveSplineType(uint key);
   virtual int curveSplineSize(uint key);
   virtual QString curveName(uint key);
   virtual QArray<uint> curveKeys();
   virtual uint curveKey(const char *name);
   virtual int curveXAxis(uint key);
   virtual int curveYAxis(uint key);

   virtual void raiseCurve(uint key);
   virtual void lowerCurve(uint key);
   
   virtual bool isEmpty(){
      return d_curveList.isEmpty();
   }
   
   virtual uint curveCount(){
      return d_curveList.count();
   }
   
   virtual SamplinCurve *firstCurve(){
      return d_curveList.first();
   }
   
   virtual SamplinCurve *nextCurve(){
      return d_curveList.next();
   }
   
   virtual SamplinCurve *currentCurve(){
      return d_curveList.current();
   }

   virtual int curveIndex(uint key);
   
   virtual SamplinCurve *findCurve(uint key){
      return d_curveDict.find(key);
   }

 
   //Axes
   SamplinScaleBox *axis(int i);
   
   virtual void setAxisTitle( int axis, const char *str){
      if(axisValid(axis)){
	 d_scale[axis]->setTitle(str);
      }
   }

   const char   *axisTitle( int axis ){
      if(axisValid(axis))
	return(d_scale[axis]->title()); 
      else return "";
     } 

   void enableAxis(int axis, bool tf = true);
   bool axisEnabled(int axis);
      
   //Grid
   
   void setGridPen(const QPen &p);
   void setGridMajPen(const QPen &p);
   void setGridMinPen(const QPen &p);
   void setGridAxis(int axis);
   
   void enableGridX(bool tf = true);
   void enableGridXMin(bool tf = true);
   void enableGridY(bool tf = true);
   void enableGridYMin(bool tf = true);
   
   bool gridXEnabled() const{ return d_grid.xEnabled();
   }
   bool gridXMinEnabled() const { return d_grid.xMinEnabled();
   }
   bool gridYEnabled() const { return d_grid.yEnabled();
   }
   bool gridYMinEnabled() const { return d_grid.yMinEnabled();
   }
   int gridXAxis() const { return d_grid.xAxis();
   }
   int gridYAxis() const { return d_grid.yAxis();
   }
   const QPen& gridMinPen() { return d_grid.minPen();
   }
   const QPen& gridMajPen() { return d_grid.majPen();
   }
   
 protected:
   virtual void setBusy(bool busy){};
   virtual void autoRefresh(){};

   QList<SamplinCurve> d_curveList;
   QIntDict<SamplinCurve> d_curveDict;
   SamplinGrid d_grid;
   SamplinScaleBox *d_scale[axisCnt];
//   QwtScaleDiv d_sdiv[axisCnt];
   
   char d_axisEnabled[axisCnt];
   
   QString d_label, filename, d_fileid, d_fileerror;
   QString d_comment;
   QwtSymbol dummySymbol;
   QPen dummyPen;
   QByteArray savedData;

   QString d_title;
   QFont d_titleFont, d_lFont,d_cFont;
   QColor d_titleColor,d_plotColor, d_panelColor,d_lColor,d_cColor;

   char d_printfit, d_printinfo;
   int d_printwidth, d_printheight;
   char d_lpos,d_cpos;
   double d_stackx,d_stacky;
   int d_stack;
};

QDataStream &operator<<( QDataStream &, SamplinPlotData &);
QDataStream &operator>>( QDataStream &, SamplinPlotData &);


#endif // SampLin_Plot_Data_included
