#include "qwt_math.h"
#include "parser.h"

//#include "parser.moc"

Parser::Mfkt Parser::mfkttab[FANZ]={{"sqrt",	sqrt},	// Quadratwurzel 
				    {"sqr",	sqr},						// Quadrat 
				    {"exp",	exp},						// e-Funktion 
				    {"ln",	log},						// nat. Logarithmus 
				    {"log",	log10},						// 10-er Logarithmus 
				    {"sinh", 	sinh},					// Sinushyperbolikus 
				    {"cosh", 	cosh},					// Cosinushyperbolikus 
			  	    {"tanh", 	tanh},					// Tangenshyperbolikus 
			 	    {"sin",  	sin},					// Sinus 
				    {"cos",	cos},						// Cosinus 
				    {"tan",	tan},						// Tangens 
				    {"arsinh",	arsinh},				// Area-Sinushyperbolikus 
				    {"arcosh", 	arcosh},				// Area-Cosinushyperbolikus 
				    {"artanh", 	artanh},				// Area-Tangenshyperbolikus 
				    {"arcsin", 	asin},					// Arcussinus 
				    {"arccos", 	acos},					// Arcuscosinus 
				    {"arctan", 	atan},					// Arcustangens 
                                    {"abs", fabs},
                                    {"sgn",sgn}
};
/*
Parser::Parser()
{
   ps_init("",MEMSIZE,STACKSIZE);
}
 */

Parser::Parser(QString name, int m_size, int s_size):Fitter()
{
   ps_init(name, m_size, s_size);
}

void Parser::ps_init(QString name, int m_size, int s_size)    
{
   memsize=m_size;
   stacksize=s_size;
   evalflg=0;
   
   fvar.resize(1);
   fstr.resize(1);
   mem=new unsigned char [memsize];
   fpardict.setAutoDelete(TRUE);
   fparnum=0;
   parsed=FALSE;
   d_fman=FALSE;
   d_range1=0;
   d_range2=1;
   stkptr=stack=new double [stacksize];
   
   setFunction(name);
   updateFunctionRange();
}

Parser::~Parser()
{
   delete []mem;
   delete []stack;
}

double Parser::eval(QString str)
{
   double erg;

   stkptr=stack;
   evalflg=1;		
   lptr=(const char*)str;
   err=0;
   heir1();
   if(*lptr!=0 && err==0) err=1;
   evalflg=0;
   erg=*stkptr;
   if(err==0) {errpos=0; return erg;}
   else {errpos=lptr-(const char*)str+1; return 0.;}                          
}

double Parser::function(double x)
{
   unsigned char token;
   
   int *pi,tmpi;
   double *pd, (**pf)(double);
   double erg, *stkptr;

   mptr=mem;
   stkptr=stack;
   
   while(1){
      switch(token=*mptr++){
       case KONST:
	 pd=(double*)mptr;
	 *stkptr=*pd++;
	 mptr=(unsigned char*)pd;
	 break;
       case XWERT:
	 *stkptr=x;
	 break;
       case PARAM:
	 pi=(int*)mptr;
	 tmpi=*pi++;
	 *stkptr=fpartbl[tmpi];
	 mptr=(unsigned char*)pi;
	 break;
       case PUSH:
	 ++stkptr;
	 break;
       case PLUS:
	 stkptr[-1]+=*stkptr;
	 --stkptr;
	 break;
       case MINUS:
	 stkptr[-1]-=*stkptr;
	 --stkptr;
	 break;
       case MULT:
	 stkptr[-1]*=*stkptr;
	 --stkptr;
	 break;
       case DIV:
	 if(*stkptr==0. && stkptr[-1]!=0.) *(--stkptr)=HUGE_VAL;
	 else if(*stkptr==0. && stkptr[-1]==0.) *(--stkptr)=(0.0/0.0);
	 else {stkptr[-1]/=*stkptr; --stkptr;}
	 break;
       case POW:
	 stkptr[-1]=pow(*(stkptr-1),*stkptr);
	 --stkptr;
	 break;
       case NEG:
	 *stkptr=-*stkptr;
	 break;
       case FKT:
	 pf=(double(**)(double))mptr;
	 *stkptr=(*pf++)(*stkptr);
	 mptr=(unsigned char*)pf;
	 break;
       case ENDE:
	 erg=*stkptr;
	 return erg;
      }
   }
}

int Parser::setFunction(QString s, bool force)
{
   int p1, p2, p3;
   int tmp=0;

   mesg="";
   QString str=s.simplifyWhiteSpace();
   
   if(!force && parsed==TRUE && str==fstr)return 0;
   if(str.isEmpty())return 0;
   
   parsed=FALSE;

   while((tmp=str.find(' '))!=-1)str.remove(tmp,1);
   
   stkptr=stack;
   err=0; errpos=1;
   p1=str.find('(');
   p2=str.find(',');
   p3=str.find(")=");
   if(p1==-1 || p3==-1 || p1>p3) {err=4; return -1;}
   if(p2==-1 || p2>p3) p2=p3;
    
   fpardict.clear();
   fname=str.left(p1);
   fvar=str.mid(p1+1, p2-p1-1);
   fstr=str;
   
   if(p2<p3-1){
      double setval;
      int tmp1,tmp2,npar=0;
      QString pstr=str.mid(p2+1,p3-p2-1);
      QString nstr,*sptr;
      
      // first find out number of parameters...
      //debug("got param string: %s",pstr.data());
      
      tmp1=0;
      while(1){
	 if((tmp2=pstr.find(',',tmp1))==-1)tmp2=pstr.length();
	 if(tmp2>tmp1){
	    tmp=pstr.find('=',tmp1);
	    if(tmp>tmp1 || tmp==-1)++npar;
	 }
	 if(tmp2==pstr.length())break;
	 tmp1=tmp2+1;
      }
      //debug("got %i params",npar);
      fpartbl.resize(npar);
      fparnum=npar;
      
      // now identify names and initialize parameters
      tmp1=0;npar=0;
      while(1){
	 if((tmp2=pstr.find(',',tmp1))==-1)tmp2=pstr.length();
	 if(tmp2>tmp1){
	    tmp=pstr.find('=',tmp1);
	    if(tmp>tmp1 || tmp==-1){
	       if(tmp!=-1 && tmp<tmp2 ){
		  sptr=new QString(pstr.mid(tmp1,tmp-tmp1));
		  fpardict.insert(npar,sptr);
		  //debug("read param #%i %s",npar,sptr->data());
		  if(tmp2>tmp+1){
		     setval=atof(pstr.mid(tmp+1,tmp2-tmp-1));
		     fpartbl[npar]=setval;
		     //debug("setting to %f",setval);
		  }
	       }
	       else {
		  sptr=new QString(pstr.mid(tmp1,tmp2-tmp1));
		  fpardict.insert(npar,sptr);
		  fpartbl[npar]=1.0;
		  //debug("read param #%i %s",npar,sptr->data());
		  //debug("test param=%s",fpardict.find(npar)->data());
	       }
	       ++npar;
	    }
	 }
	 if(tmp2==pstr.length())break;
	 tmp1=tmp2+1;
      }
   }
   else {
      fpartbl.resize(0);
   }

   mptr=mem;
   lptr=(const char*)str+p3+2;
   heir1();
   if(*lptr!=0 && err==0) err=1;		// Syntaxfehler
   addtoken(ENDE);
   
   if(err!=0){
      fname.resize(1);
      errpos=lptr-(const char*)str+1;
      errmsg();
      return -1;
   }
   
   errpos=0;

   parsed=TRUE;

//   if(fparnum>0)regress();
   if(d_autofit)regress();
   
   return 0;
}

void Parser::heir1()
{
   char c;
   
   heir2();            
   if(err!=0) return;
   
   while(1){
      switch(c=*lptr){
       default:
	 return;
       case ' ':
	 continue;
       case '+':
       case '-':
	 ++lptr;
	 addtoken(PUSH);
	 heir2();
	 if(err!=0) return;
      }
      switch(c){
       case '+':
	 addtoken(PLUS);
	 break;
       case '-':
	 addtoken(MINUS);
      }
   }
}

void Parser::heir2()
{
   if(match("-")){
      heir2();
      if(err!=0) return;
      addtoken(NEG);
   }
   else heir3();
}


void Parser::heir3()
{
   char c;

   heir4();
   if(err!=0) return;
   
   while(1){
      switch(c=*lptr){
       default:
	 return;
       case ' ':
	 continue;
       case '*':
       case '/':
	 ++lptr;
	 addtoken(PUSH);
	 heir4();
	 if(err!=0)return;
      }
		
      switch(c){
       case '*':
	 addtoken(MULT);
	 break;
       case '/':
	 addtoken(DIV);
      }
   }
}


void Parser::heir4()
{
   primary();
   if(err!=0) return;
   
   while(match("^")){
      addtoken(PUSH);
      primary();
      if(err!=0)return;
      addtoken(POW);
   }
}


void Parser::primary()
{
   
   char *p;
   int i;
   double w;
   const char *sptr;
   QString *qptr;
   
   if(match("(")){
      heir1();
      if(err==0 && match(")")==0) err=2;	// fehlende Klammer
      return;
   }
   
   if(matchstr((const char*)fvar)){
      addtoken(XWERT);
      return;
   }
	
   i=0;
   while(i<fparnum){
      if((qptr=fpardict.find(i))!=NULL)
	sptr=*qptr;
      if(matchstr(qptr->data())){
	 addtoken(PARAM);
	 addint(i);
	 return;
      }
      ++i;
   }
   
   for(i=0; i<FANZ; ++i){
      if(matchstr(mfkttab[i].mfstr)){
	 primary();
	 addtoken(FKT);
	 addfptr(mfkttab[i].mfadr);
	 return;
      }
   }
   
   if(matchstr("pi")){
      addtoken(KONST);
      addwert(M_PI);
      return;
   }
	
   if(matchstr("e")){
      addtoken(KONST);
      addwert(M_E);
      return;
   }
   
   w=strtod(lptr, &p);
   if(lptr != p){
      lptr=p;
      addtoken(KONST);
      addwert(w);
   }
   else err=1;				// Syntax-Fehler
}


int Parser::match(const char* lit)
{
   const char *p;
   
   if(*lit==0) return 0;
   while(*lptr==' ') ++lptr;
   p=lptr;
   while(*lit){
      if(*lit++!=*p++)return 0;
   }
   lptr=p;
   return 1;
}

int Parser::matchstr(const char* lit)
{
   const char *p;
   
   //   debug("match %s to %s",lit,lptr);
   
   if(*lit==0) return 0;
   while(*lptr==' ')++lptr;
   p=lptr;
   while(*lit){
      if(*lit!=*p){
	 //	 debug("differ...");
	 return 0;
      }
      if(strchr(" +-/*^()",*p)!=NULL){
	 //	 debug("2got *p=%c",*p);
	 return 0;
      }
      ++p;++lit;
   }
   if(*p!='\0' && strchr(" +-/*^()",*p)==NULL){
      //      debug("1got *p=%c",*p);
      return 0;
   }
   
   //   debug("match Ok");
   lptr=p;
   return 1;
}

void Parser::addtoken(unsigned char token)
{
   if(stkptr>=stack+stacksize-1) {err=7; return;}   
   
   if(evalflg==0){
      if(mptr>=&mem[memsize-10]) err=6;
      else *mptr++=token;
      switch(token){
       case PUSH:
	 ++stkptr; break;	
       case PLUS:
       case MINUS:
       case MULT:
       case DIV:
       case POW:
	 --stkptr;
      }
   }
   else switch(token){
    case PUSH:
      ++stkptr;
      break;
    case PLUS:
      stkptr[-1]+=*stkptr;
      --stkptr;
      break;
    case MINUS:
      stkptr[-1]-=*stkptr;
      --stkptr;
      break;
    case MULT:
      stkptr[-1]*=*stkptr;
      --stkptr;
      break;
    case DIV:
      if(*stkptr==0. && stkptr[-1]!=0.0) *(--stkptr)=HUGE_VAL;
      else if(*stkptr==0. && stkptr[-1]==0.0) *(--stkptr)=(0.0/0.0);
      else {stkptr[-1]/=*stkptr; --stkptr;}
      break;
    case POW:
      stkptr[-1]=pow(*(stkptr-1),*stkptr);
      --stkptr;
      break;
    case NEG:
      *stkptr=-*stkptr;
   }           				       
}


void Parser::addint(int a)
{  
   int *pi=(int*)mptr;
   
   if(evalflg==0){
      if(mptr>=&mem[memsize-10]) err=6;
      else {*pi++=a; mptr=(unsigned char*)pi;}
   }
   else *stkptr=a;
}


void Parser::addwert(double x)
{  
   double *pd=(double*)mptr;
    
   if(evalflg==0){
      if(mptr>=&mem[memsize-10]) err=6;
      else {*pd++=x; mptr=(unsigned char*)pd;}
   }
   else *stkptr=x;
}

void Parser::addfptr(double (*fadr)(double))
{  
   double (**pf)(double)=(double(**)(double))mptr;
    
   if(evalflg==0){
      if(mptr>=&mem[memsize-10]) err=6;
      else {*pf++=fadr; mptr=(unsigned char*)pf;}
   }
   else *stkptr=(*fadr)(*stkptr);
}

const char *Parser::parName(int i)
{
   return *fpardict.find(i);
}

int Parser::errmsg()
{
   char s1[80], *s2;
   
   switch(err){
    case 1:	s2="Syntax error"; break;
    case 2:	s2="Missing parenthesis"; break;
    case 3:	s2="Unknown function"; break;
    case 4:	s2="Invalid function variable"; break;
    case 5:	s2="Too many functions"; break;
    case 6:	s2="Token memory overflow"; break;
    case 7:	s2="Stack overflow"; break;
    default:	s2="";
   }
	
   sprintf(s1, "Parser error at position %d :\n%s", errpos, s2);
   addMessage(s1);
   //   QMessageBox::critical(0, "SampLinGraph parser", (const char*)s1);
   return err;
}	

double sqr(double x)
{
   return x*x;
}

double sgn(double x)
{
   if(x>0.0)return 1;
   if(x<0.0)return -1;
   return 0.0;
}



double arsinh(double x)
{
   return log(x+sqrt(x*x+1));
}


double arcosh(double x)
{
   return log(x+sqrt(x*x-1));
}


double artanh(double x)
{
   return log((1+x)/(1-x))/2;
}

QDataStream &operator<<( QDataStream &s, Parser &parser ){

   int i,n=parser.parNum();
   
   
   s << parser.function();
   s << parser.epsilon();
   s << (char)parser.rangeMan();
   s << parser.rangeLow();
   s << parser.rangeHigh();
   s << (char)parser.autoFit();
   
   s << n;
   
   for(i=0;i<n;++i)
     s << parser.parTbl(i);

   return(s);
}

QDataStream &operator>>( QDataStream &s, Parser &parser ){
   
   QString fname;
   int i,n,rn;
   double val,rangel,rangeh;
   char f,man;
      
   s >> fname;

   s >> val;
   parser.setEpsilon(val);
   
   s >> man;
   s >> rangel;
   s >> rangeh;
   
   s >> f;
   
   parser.setFunction(fname);     
   parser.setAutoFit(f);

   s >> n;
   rn=parser.parNum();
   
   for(i=0;i<n;++i){
      s >> val;
      if(n==rn)parser.setparTbl(i,val);
   }

   parser.setRange(man,rangel,rangeh);

   //   if(f)parser.regress(); // not possible, data not loaded at this point !
   
   return(s);
   
}

void Parser::updateFunctionRange(void)
{
   double step,var,tmp;
   int i;

   d_fmin=DBL_MAX;d_fmax=DBL_MIN;
   d_vmin=DBL_MAX;d_vmax=DBL_MIN;
   
   if(d_fman && d_range1!=d_range2 && isParsed()){
      d_vmin=qwtMin(d_range1,d_range2);
      d_vmax=qwtMax(d_range1,d_range2);
      
      step=(d_vmax-d_vmin)/2048;
      var=d_vmin;
      for(i=0;i<=2048;++i){
	 tmp=function(var);
	 //       if(isinf(tmp)==-1)tmp=-DBL_MAX/10;
	 //       if(isinf(tmp)==1)tmp=DBL_MAX/10;
	 if(!isnan(tmp) && !isinf(tmp)){
	    if(tmp>d_fmax)d_fmax=tmp;
			                  if(tmp<d_fmin)d_fmin=tmp;
	 }
	 var+=step;
      }
      //   debug("vmin=%f, vmax=%f, fmin=%f, fmax=%f",d_vmin,d_vmax,d_fmin,d_fmax);
      }
}

void Parser::setRange(bool man, double low, double high)
{
   if(man){
      d_range1=low;
      d_range2=high;
   }
   d_fman=man;
   
   updateFunctionRange();
}
