/***************************************************************************
                          bgematria.h  -  description
                             -------------------
    begin                : Tue Nov 30 1999
    copyright            : (C) 1999 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef BGEMATRIA_H
#define BGEMATRIA_H

/**
  *@author Heinz Schumann

 The class of 'KGematria' make all calculation for a hebrew text at norms
 of the (kabbalah) gematria. This it: absolut, reduct number, ordinal number,
 quadrat, atbash(absolut revers), atbash. The result is regisered in the
 public structure 'gemsum'. In variable QString 'text' make into hebrew text.
 Textstring is one letter or mony letter.
*/

#include <qobject.h>

class BGematria : public QObject
{
 Q_OBJECT

 public:
  int gemsum[8];
/**
Structure of 'gemsum'
1.   int quanti letter
2.   int quanti words
3.   int sum absolute
4.   int sum absolute revers
5.   int sum reduct
6.   int sum ordinal
7.   int sum quadrat
8.   int sum atbash (Grups absolute revers)
*/

	BGematria();
  virtual	~BGematria();

/**
  The method of 'berGematria' make all calculation for a hebrew text at norms
 of the (kabbalah) gematria and write the results in the public strukture 'gemsum'.
 Parameter is hebrew text to calculation
*/
  void berGematria(QString );
};

#endif




















