/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#include <header.hxx>
#include <metric.hxx>

Scalar criter (R2 c1,R2 c2,R2 c3, Metrica mm) {
  Scalar crit,p;
  Scalar l1,l2,l3;
  l1=norme(c1-c2,mm);
  l2=norme(c2-c3,mm);
  l3=norme(c3-c1,mm);
  p=(l1+l2+l3)/2.;
  crit=27.*((p-l1)*(p-l2)*(p-l3))/(p*p*p);
  if (fabs(crit)<1e-3) crit=0;
  return crit;
}
