/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#include  <header.hxx>
#include  <v_t1_dl.hxx>
#include  <t_t1_dl.hxx>

extern t_vecinos(Vertice_T1*,Triangulo_T1_dlist&);
 
void busca_inters(Vertice_T1_dlist* Lsommet) {
     
  Triangulo_T1_dlist* t_vec;
  Triangulo_T1_dlink* t_lk;
  Triangulo_T1* t0,*t1,*tini;
  Vertice_T1_dlink* Ls_lk;
  Arista_T1* a0;
  Vertice_T1* s0;
  int num=0;
  int ref0,ref1,refini;
  int p_inv[3];
  Boolean frontera;
  p_inv[0]=2;p_inv[1]=0;p_inv[2]=1;
  
  Ls_lk=Lsommet->principio();
  while (Ls_lk) {
    s0=Ls_lk->s;
    frontera=FALSE;
    t_vec=new Triangulo_T1_dlist;
    if (t_vec==NIL) ERROR();
    t_vecinos(s0,*t_vec);
    t_lk=t_vec->principio();
    tini=t_lk->t;
    a0=tini->a[(tini->sommet(s0))];
    frontera=a0->front;
    refini=tini->ref;
    ref0=refini;
    t0=tini;
    while (t_lk) {
      t_lk=t_lk->sig();
      if (t_lk) {
        t1=t_lk->t;
        ref1=t1->ref;
      }
      else {
        if (frontera==FALSE){
          ref1=refini;
        }
        else{
          ref1=ref0;
        }
      }
      if (ref0!=ref1) {
        a0=t0->a[p_inv[(t0->sommet(s0))]];
        if (a0->inters==FALSE && a0->front==FALSE) {
          a0->inters=TRUE; // arista con un cierto angulo.
          a0->s[0]->inters=TRUE;
          a0->s[1]->inters=TRUE;
          num++;
        }
      }
      ref0=ref1;      
      t0=t1;
    }
    delete t_vec;
    Ls_lk=Ls_lk->sig();
  }    
#ifdef DEBUG
  cout<<"Number of edges at intersections:"<<num<<endl;
#endif /* DEBUG */ 
}
