//
// Copyright (C) 1999, Mark W J Redding <grawlfang@tesco.net>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "FullMap.h"
#include "Konstellation.h"

extern "C"
{
#include "Stars.h"
}


FullMap::FullMap(QWidget* p, double s, double m, const char* n)
	: mapView(p,s,m,n)
{
}

FullMap::~FullMap()
{
}

void
FullMap::drawMap(QPainter& p)
{
int sts;

	setCursor(waitCursor);	

	p.setPen(darkGray);
	for(int i=0;i<181;i+=10) 
		p.drawLine(7,(int)(i*m_scale+7),(int)(360*m_scale+7),(int)(i*m_scale+7));
	for(int i=0;i<361;i+=15) 
		p.drawLine((int)(i*m_scale+7),7,(int)(i*m_scale+7),(int)(180*m_scale+7));

	OutlineConstellations(p);

	sts=::OpenStars(m_mag);
	for(;;)
	{
		sts=::FetchStars();
		if(sts) break;
		double ra=::getRA();
		ra=360.0-ra;
		double dec=::getDeclination();
		if(dec<0.0)
			dec=90.0+abs((int)dec);
		else
			dec=90.0-dec;
		double mag=::getVMagnitude();
		char *spec=::getSpectrum();

		switch(*(spec+1))
		{
		case 'M' : p.setPen(red);			break;
		case 'K' : p.setPen(QColor(180,113,76));	break;
		case 'G' : p.setPen(yellow);			break;
		case 'F' : p.setPen(green);			break;
		case 'A' : p.setPen(white);			break;
		case 'B' : p.setPen(blue);			break;
		case 'O' : p.setPen(QColor(180,75,175));	break;
		default  : p.setPen(white);
		}

		ra=ra*m_scale;
		dec=dec*m_scale;
		mag=(7.0-mag)/3.0*m_scale;

		int m=(int)mag+1;
		int mago=(int)mag/2;
		int x=7+(int)ra-mago;
		int y=7+(int)dec-mago;

		p.drawEllipse(x,y,m,m);

	}
	sts=::CloseStars();
	m_parent->countStars(::getStarCount(m_mag));

	setCursor(arrowCursor);	

	m_parent->showPosition(this);
}

