#include <qmsgbox.h>
#include <qfiledlg.h>

#include "import.h"
#include "worksheet.h"

#include "import.moc"


/*
 *   Import Filter base class initialization module:
 *
 *
 *   Because of trouble defining these variables inside the headerfile
 *   they will be defined here. In the headerfile import.h they are
 *   only declared extern
 *
 *   97/11/22  Adapted to singleton pattern to ensure initialization. (PS)
 *
 *   Written for the KOrigin project by
 *
 *   (C) 1997 by Martin Hfner  
 *
 */


// ***************************************************************************


void runImportFilters::importOptions (int i)
{
  importFilterList().at(i)->getOptionsSlot();
}


static runImportFilters run;


// ***************************************************************************



ImportFilterList& importFilterList ()
{
  static ImportFilterList theList;
  return theList;
}


QPopupMenu* importFilter::getImportFilterPopup ()
{
  QPopupMenu* tmpMenu = new QPopupMenu();

  importFilter* iter;

  for (iter=importFilterList().first(); iter!=0; 
       iter=importFilterList().next())
    tmpMenu->insertItem(iter->getDescription().data());

  return tmpMenu;
}


QPopupMenu* importFilter::getImportOptionsPopup ()
{
  QPopupMenu* importOptions = new QPopupMenu();

  importFilter* iter;

  for (iter=importFilterList().first(); iter!=0; 
	   iter=importFilterList().next())
    importOptions->insertItem(iter->getDescription().data());

  QObject::connect (importOptions, SIGNAL (activated (int)), &run, 
		    SLOT (importOptions (int)));

  return importOptions;
}


Worksheet* importFilter::importFromFile ()
{
  Worksheet* ws = 0;
 
  QString filename;
  QFileDialog* filedlg;
  filedlg = new QFileDialog(0, getFileFilter(), 0, "", TRUE);

  QString capt = QString ("Import ");
  capt += getDescription();
  filedlg->setCaption(capt);
  filedlg->setDir((const char*)getLatestDirectory());
  
  int result = filedlg->exec ();
  filename = filedlg->selectedFile();

  if (result == 1)
    {
      Table* T = readTable ( (const char*)filename );
      if (T == 0)
	{
	  capt = filename + "\nThis file is not in the " +
	    getDescription() + " file format.";
	  QMessageBox::warning (0, "Error: Can\'t Import", capt);
	}
      else 
	{
	  ws = new Worksheet();
	  ws->setTable(T);
	}

      // only if ok pressed
      setLatestDirectory (filedlg->dirPath ());
    }

  ws->show();

  delete filedlg;
  return (ws);
}






