#include <iostream.h>

#include <qmsgbox.h>
#include <qfiledlg.h>
#include <qtooltip.h>

#include "resultwindow.h"

#include "resultwindow.moc"


#define MAXLEN_RESULTWINDOW 300


resultWindow* result;


resultWindow::resultWindow (QWidget* parent, const char* name)
  : QMultiLineEdit (parent, name)
{
  resize (350, 200);
  setCaption ("Results");
  setWFlags (WStyle_Customize|WStyle_NoBorder|WStyle_Tool);

  hide ();

  QToolTip::add (this, "Displays KOrigin calculation results");

  menu = new QPopupMenu ();  
  menu->insertItem ("Save as", this, SLOT (saveResults()));
  menu->insertSeparator ();
  menu->insertItem ("Clear", this, SLOT (clearResults()));
}


resultWindow::~resultWindow ()
{
  delete menu;
}


void resultWindow::saveToDisk (QFile* f)
{
  f->writeBlock ("<results>\n", strlen ("<results>\n"));

  f->writeBlock ((const char*)text(), strlen((const char*)text()));
  f->writeBlock ("\n", strlen ("\n"));

  f->writeBlock ("</results>\n", strlen("</results>\n"));
}


void resultWindow::loadFromDisk (QFile* f)
{
  char* line = new char[MAXLEN_RESULTWINDOW];
  QString newText;

  f->readLine (line, MAXLEN_RESULTWINDOW);
  while (strcmp (line, "</results>\n") != 0) 
    {
      newText+=line;
      f->readLine (line, MAXLEN_RESULTWINDOW);
    }

  clear ();
  setText ((const char*)newText);
  delete [] line;
}


void resultWindow::saveResults ()
{
  QString saveName = QFileDialog::getSaveFileName (0, "*", 0, 0);
  if (saveName.isEmpty() == TRUE) return;

  QFile* f = new QFile ((const char*)saveName);
  if (f->exists() == TRUE) 
    if (QMessageBox::warning (0, "Warning", "File already exists.\nContinue?", 
			  "Yes", "No") == 1) 
      {
	delete f;
	return;
      }
  
  f->open (IO_WriteOnly);
  saveToDisk (f);
  f->close ();
}


void resultWindow::clearResults ()
{
  int i = QMessageBox::warning (0, "Warning", "Do you really want \
to clear\nthe calculation results?", "Yes", "No");
  if (i == 0) clear ();
}


void resultWindow::mousePressEvent (QMouseEvent* e)
{
  if (e->button () == RightButton)
    {
      menu->popup (e->pos()+this->geometry().topLeft());
    }
  else 
    QMultiLineEdit::mousePressEvent (e);
}
