#include "ws_gotowidget.h"


// **********************  gotoRow or Column Widget  **************************


gotoWidget::gotoWidget (QWidget*, const char* name)
  : QDialog (0, name, TRUE)
  {
    setFixedSize (260, 135);
    QString lbtext ("Goto ");

    if ( strcmp (name, "Column") == 0 ) 
      {
	setCaption ("Goto Column");
	lbtext += "Column:";
      }
    if ( strcmp (name, "Row") == 0) 
      {
	setCaption ("Goto Row");
	lbtext += "Row:";
      }
    
    lb = new QLabel (this);
    lb->setText ( (const char*)lbtext );
    lb->setGeometry (30, 30, 80, 25);
    
    line = new QLineEdit (this);
    line->setGeometry (110, 30, 120, 25);
    line->setMaxLength (256);

    ok = new QPushButton ("Ok", this);
    ok->setGeometry (30, 80, 90, 25);
    ok->setDefault (TRUE);

    cancel = new QPushButton ("Cancel", this);
    cancel->setGeometry (140, 80, 90, 25);

    connect (ok, SIGNAL (clicked()), SLOT (accept()));
    connect (cancel, SIGNAL (clicked ()), SLOT (reject()));
    connect (line, SIGNAL(returnPressed ()), SLOT (accept()));

    line->setFocus ();
  }


gotoWidget::~gotoWidget ()
  {
    delete ok;
    delete cancel;
    delete line;
    delete lb;
  }


const char* gotoWidget::getGoto ()
  {
    return ( line->text () );
  }
