/***************************************************************************
                          kscalar.h  -  description
                             -------------------
    begin                : Thu Dec 9 1999
    copyright            : (C) 1999 by B. Heath Robinson
    email                : bheath@earthlink.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSCALAR_H
#define KSCALAR_H

/**
  *@author B. Heath Robinson
  */
class KComplex;

class KScalar {

private:
	double dValue;
public:
	KScalar();
	KScalar(KScalar&);
	KScalar(const char * sNewValue, int iBase);
	virtual ~KScalar();
	virtual void setValue(const char * sNewValue, int iBase);
	virtual double getValue() const;
	virtual const char * getStringRepresentation(int iBase);


	//Mathematical Functions
	
	//Binary operators
	//KScalar operand
	virtual void add(KScalar& );
	virtual void subtract(KScalar& );
	virtual void multiply(KScalar& );
	virtual void divide(KScalar& );
	virtual void power(KScalar& );
	virtual void root(KScalar& );
	virtual void modulous(KScalar& );
	virtual void AND(KScalar& );
	virtual void OR(KScalar& );

	//Unary Operators
	virtual void negate();
	virtual void inverse();
	virtual void sine(int unit=0);
	virtual void cosine(int unit=0);
	virtual void tangent(int unit=0);
	virtual void hypSine();
	virtual void hypCosine();
	virtual void hypTangent();
	virtual void arcsine(int unit=0);
	virtual void arccosine(int unit=0);
	virtual void arctangent(int unit=0);
	virtual void hypArcsine();
	virtual void hypArccosine();
	virtual void hypArctangent();
	virtual void ln();
	virtual void log10();
	virtual void e2X();
	virtual void ten2X();
	virtual void factorial();
	virtual void compliment();
};

#endif
