#include "fft.h"
#include "oss.h"
#include "qvumeter.h"
#include <qlabel.h>
#include <ktopwidget.h>
#include <kmenubar.h>

class MYFFT : public QWidget
{
  Q_OBJECT
public:
    MYFFT(QWidget *parent);
    void setMode(int);

private slots:
    void getData(freqdata*);

private:
    Qvumeter      *vue[20];
    QLabel        *freqStr;
};

class FFT : public KTopLevelWidget
{
  Q_OBJECT
public:
    FFT();
    ~FFT();

public slots:
    void        pause();
    void        menuReturn(int);

private:
    void resizeEvent( QResizeEvent * );
    void closeEvent( QCloseEvent *e );
    void        makeMenu();
    FFTWindow   *fftwin;
    Soundcard   *card;
    KMenuBar    *mainMenu;
    MYFFT       *fftDisp;
    int muted;
};

