/****************************************************************
**
** Qvumeter: a VU-meter widget for Qt
** By Andrew D. Balsa <andrebalsa@altern.org>, June 1998
** Version 0.0.3
** Licensing: my code under GNU/GPL, Qt code under Qt special license
**
** Qvumeter class definition header file.
** Other files included are the implementation file and a main.cpp demo program.
**
** Basically this is a Qt Frame paintable widget, of geometry determined by
** the type of meter, the number of steps and the pixel dimensions of the
** GIF image used for each step. We Bitblt the LED pixmaps inside the frame
** in order to avoid flicker as much as possible.
**
** Only led, single or multiple color, basic damping, linear scale (vertical or
** horizontal) in version 0.0.3, 10 June 1998.
**
** Web site: http://www.altern.org/andrebalsa/widgets
**
** At this stage there is a nice feature implemented: the widget will accept any
** GIF file (including transparency information) as the basic LED. A few sample
** small GIF files are included here.
**
** Planned features include:
** 	- More damping options (see algorithm below). (version 0.0.4)
** 	- Linear/log/dB scales. (version 0.0.5)
** 	- Fluorescent look, LCD look. (version 0.0.6)
**	- Overload the constructor, cleanup the code. (version 0.0.7)
**	- Analog VU meter look. (version 0.1)
**	- Resizable. (version 0.2)
**	- Audio alerts using KDE audio server. (version 0.3)
**	- Resettable "Hold" marks. (version 0.4)
**	- Suggestions welcome for versions 0.5+ :-)
**

KSpectrum
Carl van Schaik (carl@leg.uct.ac.za)

This widget has been HIGHLY modified from the original for use in KSpectrum
by Carl van Schaik to provide greatly enhanced speed, various effects and
integration into KSpectrum.

****************************************************************/

#ifndef VUMETER_H
#define VUMETER_H

#include <qframe.h>

#define MAXLEDS 100	// maximum number of LEDs

class Qvumeter : public QFrame
{
    Q_OBJECT
public:
    Qvumeter( int ledNumber=33, int minRange=0, int maxRange=99, int
    vuDamping=0, int valStop1=23, int valStop2=28, int valStop3=31,
    unsigned char ledOrient='v',
    QWidget *parent=0, const char *name=0, WFlags f=0 );

    int ledNumber() const;
    int activeLED() const;
    int getMinInput() const;
    int getMaxInput() const;

public slots:
    void setValue( int );
    void setMode(int);

protected:
//    void drawContents( QPainter * );
    void timerEvent( QTimerEvent * );
    void paintEvent( QPaintEvent * );

private:
    QPixmap *ledPixmap[4], *whitePix;
    unsigned int dampingFactor;
    int minInput, maxInput, min, max, timer;
    int ledStop1, ledStop2, ledStop3;	// define up to 4 led colors
    unsigned int ledWidth, ledHeight, fullHeight;
    unsigned int activeLed;
    unsigned int previousLed;
    unsigned int stepsNo;
    unsigned char isVert;
    void *pled[MAXLEDS];	// each pointer points to a different LED color
    unsigned int maxLed, mode, sticky;
    void fullCalc();
};


inline int Qvumeter::getMinInput() const
{
    return minInput;
}

inline int Qvumeter::getMaxInput() const
{
    return maxInput;
}

inline int Qvumeter::ledNumber() const
{
    return stepsNo;
}

inline int Qvumeter::activeLED() const
{
    return activeLed;
}


#endif // VUMETER_H

