#ifndef __KTHEME_H__
#define __KTHEME_H__

#include <qlistbox.h>
#include <qstring.h>
#include <qstrlist.h>

#include <kconfig.h>
#include <kcontrol.h>
#include <knewpanner.h>


/**
 *
 * @short A GUI interface class to the Theme class.
 * @author KDE Theme Team
 *
 * @see Theme
 */
class KTheme : public KConfigWidget {
    Q_OBJECT

public:
    KTheme(QWidget *parent=0, const char *name=0);
    ~KTheme();

    void addTheme(const QString &themeName, bool isGlobal);
    bool isGlobalInstall() const;

public slots:
    virtual void loadSettings();
    virtual void applySettings();

protected:
    void initUI();
    void writeSettings();
    void installTheme(const QString &fileName, bool isGlobal);

protected slots:
    void addLocalSelected();
    void addGlobalSelected();
    void listBoxItemHighlighted();

private:
    QString lastTheme_,
            lastDir_;
    bool lastThemeGlobal_;
    QStrList theLocalThemes_,
             theGlobalThemes_;
    QListBox *localListBox_,
             *globalListBox_;
    KNewPanner *panner_;
    KConfig *kthemeConfig_;
    int pannerSepPos_;
};


#endif  // __KTHEME_H__
