#include <stdlib.h>

#include <iostream.h>

#include <qdir.h>
#include <qfile.h>
#include <qfileinf.h>
#include <qstring.h>

#include <kapp.h>
#include <kwm.h>

#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xos.h> 

#include "theme.h"


const QString Theme::LOCAL_THEMES_DIR = KApplication::localkdedir()
                                            + "/share/themes/";
const QString Theme::GLOBAL_THEMES_DIR = KApplication::kde_datadir() 
                                             + "/themes/";

static const char *soundList[] =
{
    "Desktop1",
    "Desktop2",
    "Desktop3",
    "Desktop4",
    "Desktop5",
    "Desktop6",
    "Desktop7",
    "Desktop8",
    "WindowActivate",
    "WindowOpen",
    "WindowClose",
    "Startup",
    "WindowShadeUp",
    "WindowShadeDown",
    "WindowIconify",
    "WindowDeIconify",
    "WindowMaximize",
    "WindowUnMaximize",
    "WindowSticky",
    "WindowUnSticky",
    "WindowTransNew",
    "WindowTransDelete",
    "Logout",
    "LogoutMessage",
    "WindowMoveStart",
    "WindowMoveEnd",
    "WindowResizeStart",
    "WindowResizeEnd",
    0,
};             

static const char *colorList[] =
{
    "foreground",
    "selectForeground",
    "selectBackground",
    "background",
    "windowForeground",
    "windowBackground",
    0,
}; 

static const char *colorList2[] =
{
    "activeBlend",
    "inactiveBackground",
    "activeBackground",
    "inactiveBlend",
    "inactiveForeground",
    "activeForeground",
    0,
}; 

static const char *backgroundList[] =
{
    "WallpaperMode",
    "Pattern",
    "UseWallpaper",
    "Wallpaper",
    "ColorMode",
    "Color1",
    "Color2",
    "OrientationMode",
    0,
};

static const char *desktopList[] =
{
    "Desktop1", "Desktop2", "Desktop3",
    "Desktop4", "Desktop5", "Desktop6",
    "Desktop7", "Desktop8", "Desktop9",
    "Desktop10", "Desktop11", "Desktop12",
    "Desktop13", "Desktop14", "Desktop15",
    "Desktop16", "Desktop17", "Desktop18",
    "Desktop19", "Desktop20", "Desktop21",
    "Desktop22", "Desktop23", "Desktop24",
    "Desktop25", "Desktop26", "Desktop27",
    "Desktop28", "Desktop29", "Desktop30",
    "Desktop31", "Desktop22",
    0,
};

// -FIXME- we need to get some error checking here.  Make sure we're not
// overwriting existing themes, make sure directories are being created
// properly, etc.
const QString Theme::install(const QString &fileName, bool globalInstall)
{
    if (!QFile::exists(fileName)) {
        debug("Theme::install() - file: %s doesn't exist!\n", fileName.data());
	throw NonExistant();
    }
    
    const QString themeName = QFileInfo(fileName).baseName();
    QString dir;

    if (globalInstall)
	dir = GLOBAL_THEMES_DIR + themeName;
    else
	dir = LOCAL_THEMES_DIR + themeName;

    QDir().mkdir(dir);

    // -FIXME- Silly, I know! =)  Just a temp hack. -Josh
    QString buf = "tar -C " + dir + " -zxf " + fileName;

    int ret = system(buf.data());
    if (ret == -1)
	; // -FIXME- do something

    return(themeName);
}

static int _getprop(Window w, Atom a, Atom type, long len, unsigned char **p)
{
    Atom real_type;
    int format;
    unsigned long n,
		  extra;
    int status;

    status = XGetWindowProperty(qt_xdisplay(), w, a, 0L, len, false, type,
                                &real_type, &format, &n, &extra, p);
    
    if (status != Success || *p == 0)
	return(-1);

    if (!n)
	XFree((void*) *p);
    
    return(n);
}

static bool getSimpleProperty(Window w, Atom a, long &result)
{
    long *p = 0;

    if (_getprop(w, a, a, 1L, (unsigned char **) &p) <= 0)
	return(false);

    result = p[0];
    XFree((char *) p);

    return(true);
}

void Theme::activate(const QString &themeName, bool isGlobalTheme)
{
    QString configFile;

    if (isGlobalTheme)
	configFile = GLOBAL_THEMES_DIR + themeName + "/" +
                         themeName + ".ktheme";
    else
	configFile = LOCAL_THEMES_DIR + themeName + "/" + themeName + ".ktheme";

    KConfig themeConfig(0L, configFile);
    
    themeConfig.setGroup("Global");
    QString str = themeConfig.readEntry("Name");
    cout << "str == " << str << endl;

    themeConfig.setGroup("Style");
    str = themeConfig.readEntry("GUI");
    if (!str.isEmpty()) {
	themeConfig.setGroup("KDE");
	themeConfig.writeEntry("widgetStyle", str, true, true);
    }

    themeConfig.sync();

    // Sound Configuration
    KConfig *soundconfig = new KConfig(
                                kapp->kde_configdir()  + "/" + "kwmsoundrc",
				kapp->localconfigdir() + "/" + "kwmsoundrc");

    soundconfig->setGroup("SoundConfiguration");
    themeConfig.setGroup("SoundEvents");
    for (int i = 0; soundList[i]; i++)
        changeSound(&themeConfig, soundconfig, soundList[i], themeName,
	            isGlobalTheme);

    soundconfig->sync();
    delete soundconfig;

    // Desktop Configuration

    KConfig *desktopconfig = new KConfig(
                                 kapp->kde_configdir()  + "/" + "kdisplayrc",
			 	 kapp->localconfigdir() + "/" + "kdisplayrc");

    for (int j = 0; desktopList[j]; j++) {
	desktopconfig->setGroup(desktopList[j]);
	themeConfig.setGroup(desktopList[j]);
	for (int i = 0; backgroundList[i]; i++)
	    changeDesktop(&themeConfig, desktopconfig, backgroundList[i],
			  themeName, isGlobalTheme);
    }

    desktopconfig->sync();
    delete desktopconfig;

    // Color Configuration
    themeConfig.setGroup("Color");
    for (int i = 0; colorList[i]; i++) {
	themeConfig.setGroup("Color");
        changeColor(&themeConfig, colorList[i], "General");
    }

    for (int i = 0; colorList2[i]; i++) {
	themeConfig.setGroup("Color");
        changeColor(&themeConfig, colorList2[i], "WM");
    }

    // --begin
    // Ripped from general.cpp in kcmdisplay.  kcmdisplay was written
    // by Mark Donohoe (thanks Mark!) and was converted to a kcc module
    // by Matthias Hoelzer.  The following code, up until '-! end !-', is a
    // slightly modified version of the code so it could be dropped in
    // here.  Any bugs are probably my (Josh) fault =)
    XEvent ev;
    unsigned int i,
                 nrootwins;
    Window  dw1,
            dw2,
	   *rootwins;
    Display *kde_display = KApplication::desktop()->x11Display();
    int (*defaultHandler)(Display *, XErrorEvent *);

    defaultHandler = XSetErrorHandler(0);

    Window root = RootWindow(kde_display, DefaultScreen(kde_display));
    XQueryTree(kde_display, root, &dw1, &dw2, &rootwins, &nrootwins);

    // Matthias
    Atom a = XInternAtom(qt_xdisplay(), "KDE_DESKTOP_WINDOW", false);

    for (i = 0; i < nrootwins; i++) {
	long result = 0;

        getSimpleProperty(rootwins[i], a, result);

	if (result) {
	    ev.xclient.type = ClientMessage;
	    ev.xclient.display = kde_display;
	    ev.xclient.window = rootwins[i];
	    ev.xclient.message_type = 
	        XInternAtom(kde_display, "KDEChangeGeneral", false);
	    ev.xclient.format = 32;

	    XSendEvent(kde_display, rootwins[i], false, 0L, &ev);
	}
    }

    XFlush(kde_display);
    XSetErrorHandler(defaultHandler);

    XFree((void *) rootwins);
    // -! end !-

    KWM::sendKWMCommand("kbgwm_reconfigure"); // Needed to update background

    KWM::sendKWMCommand("syssnd_restart");
}


bool Theme::changeSound(KConfig *themeConfig, KConfig *soundConfig, 
                        const QString &soundName, const QString &themeName,
			bool isGlobal)
{
    QString str = themeConfig->readEntry(soundName);
    if (!str.isEmpty()) {
        if (isGlobal) {
	    soundConfig->writeEntry(soundName, GLOBAL_THEMES_DIR 
	                                           + themeName + "/" + str);
	} else {
	    soundConfig->writeEntry(soundName, LOCAL_THEMES_DIR 
	                                           + themeName + "/" + str);
	}

	return(true);
    }

    return(false);
}

bool Theme::changeDesktop(KConfig *themeConfig, KConfig *displayConfig,
			  const QString &displayName, const QString &themeName,
			  bool isGlobal)
{
    QString str = themeConfig->readEntry(displayName);

    if (!str.isEmpty()) {
	if (displayName == "Wallpaper" && str != "No wallpaper") {
	    if (isGlobal) {
		displayConfig->writeEntry(displayName, GLOBAL_THEMES_DIR 
		                                       + themeName + "/" + str);
	    } else {
		displayConfig->writeEntry(displayName, LOCAL_THEMES_DIR 
		                                       + themeName + "/" + str);
	    }
	} else {
	    displayConfig->writeEntry(displayName, str);
       	}

	return(true);
    }

    return(false);
}

bool Theme::changeColor(KConfig *themeConfig, const QString &colorName,
                        const char *entry)
{
    QString str = themeConfig->readEntry(colorName);
    if (!str.isEmpty()) {
	/* This looks weird, the 2:nd true makes it change /.kderc instead */
	//      const char *currentGroup = themeConfig->group();
	themeConfig->setGroup(entry);
	themeConfig->writeEntry(colorName, str, true, true);
	//      themeConfig->setGroup(currentGroup);
	return(true);
    }

    return(false);
}
