/*************************************************************************
 *                                                                       *
 *  KTheme                                                               *
 *                                                                       *
 * This file is part of the KTheme-Package. For detail information about *
 * this program have a look at the README-File.                          *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@ebs-net.com                                        *
 *                                                                       *
 *************************************************************************/

#include "kcontrol.h"
#include "ktheme.h"

KThemeApp::KThemeApp(int &argc, char **argv, const char *name):KControlApplication(argc, argv, name){
	if (runGUI()){
		kthemegfxconfig=new KThemeGfxConfig(dialog, 0, false);
		kthemesoundconfig=new KThemeSoundConfig(dialog, 0, FALSE);
		kthemecolorconfig=new KThemeColorConfig(dialog, 0, FALSE);
		kthemeinfo=new KThemeInfo(dialog, 0, FALSE);
	       	addPage(kthemegfxconfig, klocale->translate("Wallpaper"), "ktheme-1.html");
        	addPage(kthemesoundconfig, klocale->translate("Sound"), "ktheme-2.html");
        	addPage(kthemecolorconfig, klocale->translate("Colors"), "ktheme-3.html");
        	addPage(kthemeinfo, klocale->translate("Info"), "ktheme.html");
		dialog->show();
	}
}


void KThemeApp::init(){
	KThemeGfxConfig *themegfxconfig = new KThemeGfxConfig(0,0,true);
	delete themegfxconfig;
	KThemeSoundConfig *themesoundconfig = new KThemeSoundConfig(0, 0, TRUE);
	delete themesoundconfig;
	KThemeColorConfig *themecolorconfig = new KThemeColorConfig(0, 0, TRUE);
	delete themecolorconfig;
	KThemeInfo *themeinfo = new KThemeInfo(0, 0, TRUE);
	delete themeinfo;

}


void KThemeApp::apply(){
	QApplication::setOverrideCursor( waitCursor );
	if (kthemegfxconfig) kthemegfxconfig->applySettings();
	if (kthemecolorconfig) kthemecolorconfig->applySettings();
	if (kthemesoundconfig) kthemesoundconfig->applySettings();
	QApplication::restoreOverrideCursor();
}

int main(int argc, char **argv){
	KThemeApp app(argc, argv, "ktheme");
	app.setTitle(klocale->translate("KTheme Manager"));
  
	if (app.runGUI())
		return app.exec();
	else{
		app.init();
		return 0;
  	}
}
