/*************************************************************************
 *                                                                       *
 *  KTheme                                                               *
 *                                                                       *
 * This file is part of the KTheme-Package. For detail information about *
 * this program have a look at the README-File.                          *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * Parts take from the KDE Display color scheme setup module,            *
 *  Copyright (c)  Mark Donohoe 1997                                     *
 *  Converted to a kcc module by Matthias Hoelzer 1997                   *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@ebs-net.com                                        *
 *                                                                       *
 *************************************************************************/

#include <qdir.h>
#include <qlistbox.h>

#include <kapp.h>
#include <klocale.h>
#include <kmsgbox.h>

#include "kthemecolorconfig.h"
#include "widgetcanvas.h"
#include "dialogs.h"

KThemeColorConfig::~KThemeColorConfig (){
}

KThemeColorConfig::KThemeColorConfig (QWidget *parent, const char *name, Theme *t):KConfigWidget (parent, name){
	theme=t;
	path_scheme=KApplication::kde_wallpaperdir()+"/../color-schemes";	// This is a very crapy way, but I dont know a better one :(

	saveScheme=new QPushButton(this);
	saveScheme->resize(300,30);
	saveScheme->setText(klocale->translate("Save Current Scheme As"));

	deleteScheme=new QPushButton(this);
	deleteScheme->resize(300,30);
	deleteScheme->setText(klocale->translate("Remove selected Scheme"));

	preview = new WidgetCanvas( this );
	preview->setFixedHeight( 150 );

	loadSettings();

	scheme_Listbox = new QListBox( this, "listBox" );
	scheme_Listbox->resize(200,200);
	scheme_Listbox->setAutoUpdate( FALSE );

	QDir d(path_scheme);
	d.setFilter( QDir::Files );
	d.setSorting( QDir::Name );
	d.setNameFilter("*.kcsrc");

	scheme_Listbox->clear();
	scheme_Listbox->insertItem( klocale->translate("Current scheme"));
	scheme_Listbox->setCurrentItem(0);
	for ( unsigned int i=0; i<d.count(); i++ ) {
		QString tmp=d[i];
		tmp=tmp.left(tmp.length()-6);
		scheme_Listbox->insertItem(tmp);
	}
	scheme_Listbox->setAutoUpdate(TRUE);

	loadScheme(path_scheme+"/"+scheme_Listbox->text(0)+".kcsrc");
	preview->drawSampleWidgets();

	connect(scheme_Listbox, SIGNAL(highlighted(int)),SLOT(selectScheme(int)));
	connect(theme,SIGNAL(themeLoaded()),SLOT(themeChanged()));
	connect(saveScheme, SIGNAL(clicked()),SLOT(slot_saveScheme()));
	connect(deleteScheme, SIGNAL(clicked()),SLOT(slot_deleteScheme()));

	resize(450,430);
	setMinimumSize(size());
	oldscheme=scheme_Listbox->text(scheme_Listbox->currentItem());
}

void KThemeColorConfig::resizeEvent(QResizeEvent *){
	preview->setGeometry(20,20,width()-40,200);
	preview->drawSampleWidgets();
	scheme_Listbox->setGeometry(20,190,width()-40,height()-250);
	saveScheme->setGeometry(20,height()-45,width()/2-40,30);
	deleteScheme->setGeometry(width()/2+20,height()-45,width()/2-40,30);
}

void KThemeColorConfig::selectScheme(int index){
	QApplication::setOverrideCursor( waitCursor );
	QString tmp=scheme_Listbox->text(index);
	loadScheme(tmp);
	theme->setColorScheme(tmp);
	preview->drawSampleWidgets();
	QApplication::restoreOverrideCursor();
}

void KThemeColorConfig::loadScheme(QString name){
	KConfigBase 	*config;
	bool		ftyp;

	ftyp=(scheme_Listbox->currentItem()==0);
	
	if (ftyp){
		config=kapp->getConfig();
	}else{
		config=new KSimpleConfig(path_scheme+"/"+name+".kcsrc");
	}

	if (ftyp)
		config->setGroup( "General" );
	else
		config->setGroup( "Color Scheme" );

	preview->txt		=config->readColorEntry( "foreground", &black );
	preview->back		=config->readColorEntry( "background", &lightGray );
	preview->select		=config->readColorEntry( "selectBackground", &darkBlue);
	preview->selectTxt	=config->readColorEntry( "selectForeground", &white );
	preview->window		=config->readColorEntry( "windowBackground", &white );
	preview->windowTxt 	=config->readColorEntry( "windowForeground", &black );
	
	if (ftyp) config->setGroup( "WM" );
	
	preview->iaTitle	=config->readColorEntry( "inactiveBackground", &darkGray);
	preview->iaTxt		=config->readColorEntry( "inactiveForeground", &lightGray );
	preview->iaBlend	=config->readColorEntry( "inactiveBlend", &lightGray );
	preview->aTitle		=config->readColorEntry( "activeBackground", &darkBlue );
	preview->aTxt		=config->readColorEntry( "activeForeground", &white );
	preview->aBlend		=config->readColorEntry( "activeBlend", &black );

	if (ftyp) config->setGroup( "KDE" );

	preview->contrast	=config->readNumEntry( "contrast", 7 );

}

void KThemeColorConfig::writeSettings(){
	writeSettings(kapp->getConfig(),true);
}

void KThemeColorConfig::writeSettings(QString name){
	writeSettings(new KSimpleConfig(name),false);
}

void KThemeColorConfig::writeSettings(KConfigBase *config,bool ftyp){
	if (ftyp)
		config->setGroup( "General" );
	else
		config->setGroup( "Color Scheme" );
	config->writeEntry("background", preview->back, true, true);
	config->writeEntry("selectBackground", preview->select, true, true);
	config->writeEntry("foreground", preview->txt, true, true);
	config->writeEntry("windowForeground", preview->windowTxt, true, true);
	config->writeEntry("windowBackground", preview->window, true, true);
	config->writeEntry("selectForeground", preview->selectTxt, true, true);

	if (ftyp) config->setGroup( "WM" );
	config->writeEntry("activeForeground", preview->aTxt, true, true);
	config->writeEntry("inactiveBackground", preview->iaTitle, true, true);
	config->writeEntry("inactiveBlend", preview->iaBlend, true, true);
	config->writeEntry("activeBackground", preview->aTitle, true, true);
	config->writeEntry("activeBlend", preview->aBlend, true, true);
	config->writeEntry("inactiveForeground", preview->iaTxt, true, true);

	if (ftyp) config->setGroup( "KDE" );
	config->writeEntry("contrast", preview->contrast, true, true);
	config->sync();
}

void KThemeColorConfig::applySettings(){
	QString tmp=scheme_Listbox->text(scheme_Listbox->currentItem());
	if (oldscheme!=tmp){
		oldscheme=tmp;
		writeSettings();
	}
}

void KThemeColorConfig::loadSettings(){
}

void KThemeColorConfig::themeChanged(){
	int citem=-1;
	QString st=theme->getColorScheme();
	for (unsigned int i=0;i<scheme_Listbox->count();i++) if (scheme_Listbox->text(i)==st) citem=i;
	
	if (citem==-1){
		KMsgBox *error=new KMsgBox (this,klocale->translate("Error"),klocale->translate("Couldnt find saved Colortheme!"),KMsgBox::EXCLAMATION,"Ok");
		error->show();
	}else{
		scheme_Listbox->setCurrentItem(citem);
	}
}


void KThemeColorConfig::slot_saveScheme(){
	GetNameWindow *gnw=new GetNameWindow();
	if (gnw->openWindow("Enter Name")){
		QString 	name=gnw->getInput();
		bool		ex=true;
		
		for (unsigned int i=0;i<scheme_Listbox->count();i++) if (QString(scheme_Listbox->text(i))==name) ex=false;
		if (ex){
			scheme_Listbox->setCurrentItem(0);
			loadScheme(scheme_Listbox->text(0));
			writeSettings(path_scheme+"/"+name+".kcsrc");
			scheme_Listbox->insertItem(name);
			scheme_Listbox->setCurrentItem(scheme_Listbox->count()-1);
			debug("Theme added");
		}else{
			KMsgBox *er=new KMsgBox(this,klocale->translate("Error"),klocale->translate("Schemename already used."),KMsgBox::EXCLAMATION,"Ok");
			er->show();
		}
	}
	delete(gnw);
}

void KThemeColorConfig::slot_deleteScheme(){
	KMsgBox *q=new KMsgBox ();
	if (scheme_Listbox->currentItem()>0){
		if (q->yesNo(this,klocale->translate("Question"),klocale->translate("Are you sure?"),KMsgBox::EXCLAMATION)==1){
			QDir d(path_scheme);
			d.remove(path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+".kcsrc");
			scheme_Listbox->removeItem(scheme_Listbox->currentItem());
			debug("Theme deleted!");
		}
	}
	delete(q);
}

