/*************************************************************************
 *                                                                       *
 *  KTheme                                                               *
 *                                                                       *
 * This file is part of the KTheme-Package. For detail information about *
 * this program have a look at the README-File.                          *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@ebs-net.com                                        *
 *                                                                       *
 *************************************************************************/

#ifndef KTHEMEMAN_H
#define KTHEMEMAN_H

#include "theme.h"

#include <qlabel.h>
#include <qlistbox.h>
#include <qpushbt.h>
#include <kcontrol.h>

class KThemeMan : public QWidget{
	Q_OBJECT
public:
	KThemeMan(QWidget *parent=0, const char *name=0, Theme *t=NULL);
	~KThemeMan();
	void 		resizeEvent(QResizeEvent *);
	void 		loadConf();
	void 		saveConf();


private:
	QListBox	*theme_box;
	Theme		*theme;
	QPushButton	*saveTheme;
	QPushButton	*createNew;
	QPushButton	*removeTheme;
	int		old_item;
	QString		themepath;

private slots:
	void		slot_addTheme();
	void		slot_removeTheme();
	void		slot_saveChanges();
	void		slot_changeListItem(int item);
};

#endif


