/*************************************************************************
 *                                                                       *
 *  KTheme                                                               *
 *                                                                       *
 * This file is part of the KTheme-Package. For detail information about *
 * this program have a look at the README-File.                          *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@ebs-net.com                                        *
 *                                                                       *
 *************************************************************************/

#include "theme.h"

#include <kapp.h>
#include <kwm.h>
#include <ksimpleconfig.h>

#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

// Apply routines

static int _getprop(Window w, Atom a, Atom type, long len, unsigned char **p){
  Atom real_type;
  int format;
  unsigned long n, extra;
  int status;
  
  status=XGetWindowProperty(qt_xdisplay(),w,a,0L,len,False,type,&real_type,&format,&n,&extra,p);
  if (status != Success || *p == 0) return -1;
  if (n == 0) XFree((void*) *p);

  return n;
}

static bool getSimpleProperty(Window w, Atom a, long &result){
  long *p = 0;
  
  if (_getprop(w, a, a, 1L, (unsigned char**)&p) <= 0) return FALSE;
  
  result = p[0];
  XFree((char *) p);
  return TRUE;
}

int dropError(Display *, XErrorEvent *){
	return 0;
}

void applyColors(){
	XEvent 			ev;
	unsigned 		int i,nrootwins;
	Window 			dw1,dw2,*rootwins;
	Display 		*disp;
	Atom			KDEChangePalette;
	Window          	root;
	int 			screen;

	disp=KApplication::desktop()->x11Display();
	KDEChangePalette = XInternAtom(disp, "KDEChangePalette", False);
	screen = DefaultScreen(disp);
	root = RootWindow(disp, screen);

	int (*defaultHandler)(Display *, XErrorEvent *);
	defaultHandler=XSetErrorHandler(dropError);
	XQueryTree(disp, root, &dw1, &dw2, &rootwins, &nrootwins);
	Atom a = XInternAtom(qt_xdisplay(), "KDE_DESKTOP_WINDOW", False);
	for (i = 0; i < nrootwins; i++) {
	  long result = 0;
	  getSimpleProperty(rootwins[i],a, result);
	  if (result){
	    ev.xclient.type = ClientMessage;
	    ev.xclient.display = disp;
	    ev.xclient.window = rootwins[i];
	    ev.xclient.message_type = KDEChangePalette;
	    ev.xclient.format = 32;
	    
	    XSendEvent(disp, rootwins[i] , False, 0L, &ev);
	  }
	}
	XFlush(disp);
	XSetErrorHandler(defaultHandler);
	
	XFree((void *) rootwins);
}

// Class

Theme::~Theme(){
}

Theme::Theme():QObject(){
	changed=false;
	gfx_change=false;
	colorScheme_old="";
	soundScheme_old="";
}

void Theme::load(QString file){
	KConfigBase *config;
	config=new KSimpleConfig(file);

	config->setGroup("General");
	colorScheme=config->readEntry("colorScheme","CDE");
	soundScheme=config->readEntry("soundScheme","alien");

	config->setGroup("GFX");

	for (int i=0;i<10;i++){
		QString tmp;
		tmp.sprintf("pic%d",i);
		setWallpaper(config->readEntry(tmp),i);
		tmp.sprintf("mode%i",i);
		QString s=config->readEntry(tmp,"Tiled");
		if (!s.isNull()){
			if (s=="Tiled") 	setWallpaperArg(i,0,true); else setWallpaperArg(i,0,false);
			if (s=="Centred")	setWallpaperArg(i,1,true); else setWallpaperArg(i,1,false);
			if (s=="Scaled") 	setWallpaperArg(i,2,true); else setWallpaperArg(i,2,false);
		}else setWallpaperArg(i,0,true);
	}

	emit themeLoaded();

	debug("Loading ("+file+")");
	changed=false;
}

void Theme::save(QString file){
	KConfigBase *config;
	config=new KSimpleConfig(file);

	config->setGroup("General");
	config->writeEntry("colorScheme", colorScheme);
	config->writeEntry("soundScheme", soundScheme);

	config->setGroup("GFX");
	for(unsigned i=0;i<10;i++){
		QString tmp;
		tmp.sprintf("pic%i",i);
		config->writeEntry(tmp,desktop_gfx[i]);
		tmp.sprintf("mode%i",i);
		config->writeEntry(tmp, "Tiled" );
		if (getWallpaperArg(i,0)) config->writeEntry(tmp,"Tiled");
		if (getWallpaperArg(i,1)) config->writeEntry(tmp,"Centred");
		if (getWallpaperArg(i,2)) config->writeEntry(tmp,"Scaled");
	}

	config->sync();

	debug("Saving ("+file+")");
	changed=false;
}

void Theme::setToDefault(){
	changed=true;
}

void Theme::setColorScheme(QString s){
	changed=true;
	colorScheme=s;
}

QString Theme::getColorScheme(){
	return(colorScheme);
}

void Theme::setSoundScheme(QString s){
	changed=true;
	soundScheme=s;
}

QString Theme::getSoundScheme(){
	return(soundScheme);
}

void Theme::setWallpaper(QString tit,int index){
	if (index>10) index=10;
	desktop_gfx[index]=tit;	
	gfx_change=true;
}

QString Theme::getWallpaper(int index){
	if (index>10) index=10;
	return desktop_gfx[index];
}

void Theme::setWallpaperArg(int desktop, int typ, bool arg){
	if (desktop>10) desktop=10;
	if (typ>3) typ=3;
	desktop_arg[desktop][typ]=arg;
	gfx_change=true;
}

bool Theme::getWallpaperArg(int desktop, int typ){
	if (desktop>10) desktop=10;
	if (typ>3) typ=3;
	return desktop_arg[desktop][typ];
}

void Theme::applyTheme(){
	debug("Applying:");
	if (colorScheme_old!=colorScheme) {
		debug("Saving Colorscheme                    :"+colorScheme);
		applyColors();
		colorScheme_old=colorScheme;
	}
	if (soundScheme_old!=soundScheme) {
		debug("Applying Soundscheme                  :"+soundScheme);
		KWM::sendKWMCommand("syssnd_restart");
		soundScheme_old=soundScheme;
	}
	if (gfx_change){
		debug("Applying Gfx");
		KWM::sendKWMCommand("kbgwm_reconfigure");
		gfx_change=false;
	}
}


