/*****************************************************************************
 * This software is distributed under the terms of the General Public License.
 *
 * Program :   kastrolog 5.4 beta 3
 * Authors : see the AUTHORS file
 * E-Mail  : Llyra@altavista.com
*****************************************************************************/ 


#include <drag.h>
#include <qscrollview.h>
#include <qpicture.h>
#include <qpainter.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qlist.h>
#include <kstatusbar.h>

extern "C"
{
#ifndef ASTROLOG
#include "astrolog.h"
#endif
#undef bool
}

#define OFFSET FONTY

enum savetype { SaveInfo, SaveOutput, SaveText, SavePostscript, SaveBitmap, SavePicture, SaveSettings };

enum GraphMode { GMGraph, GMText, GMDblbuf };

void NCheck(QLineEdit*, int, int, const char *, int*);
void FCheck(QLineEdit*, real, real, const char *, real*);

// QT 2 already defines a QStringList, but not QT 1
#if (QT_VERSION < 200)
class QStringList: public QList<QString>
{
public:
  typedef QString Iterator;
};

#define latin1 data
#define INC(s, sl) s= sl->next()
#else
#define INC(s, sl) s++
#endif

class AstroStringList: public QStringList
{
public:
  AstroStringList();
  void clear();
};

enum Direction { DirUp, DirDown, DirTop, DirBottom };

class MyDropZone : public KDNDDropZone
{
 public:
  MyDropZone(QWidget* _parent) : KDNDDropZone(_parent, DndURL) {}
  void drop( char *_data, int _size, int _type, int _x, int _y );
};

class AstroWidget : public QScrollView
{

  Q_OBJECT

public:

  AstroWidget(QWidget *, const char *);
  void drawContentsOffset ( QPainter *, int ox, int oy, int cx, int cy, int cw, int ch );
  inline QPainter* GetP() { return pain; }
  inline char GetKey() { return key; }
  inline int GetScale() { return scale; }
  inline int GetNumber() { return number; }
  void resizeEvent(QResizeEvent * );
  void keyPressEvent(QKeyEvent* e);
  void setPaint(char c = 0);
  void Inputfile(CI& ci = ciCore);
  void OutputFile(savetype st = SaveInfo);
  void PrintDialog();
  void Print();
  void RunLine(char *);
  void Command();
  void RunMacro(int);
  void SetChartInfo(CI&);
  void SetChartDefaultInfo();
  void SetRelation(int);
  void ResizeChart() { not(Resize); };
  void SetPalette();
  void SetEAColors();
  void AspectSettings();
  void ObjectSettings(const char*, int, int);
  void Restrict(const char*, byte*, byte*);
  void ToggleObj(int, int, bool);
  void RestrictStar();
  void CalculationSettings();
  void ObscureSetting();
  void ChartType(void*, char);
  void Anim(int);
  bool Transits();
  bool Progressions();
  void ChartSettings();
  void GraphicSettings();
  void SetDir(int);
  inline void SetPause() { not(Pause); }
  void TimedExpos();
  void ListFile(char*);
  void About();
  GraphMode GetGm();
  void SetGm(GraphMode g); 
  void PutText(char *, bool);
  void ColoredText();
  void Scroll(Direction);

public slots:

  void timerslot();

private:

  void PrintTheChart(_bool, _bool);

  QPicture *qpic;
  QPainter *pain;
  QPrinter *print;
  QTimer *tim;
  QPixmap *dblbuf;
  QStringList *sl;
  int jrate, scale, number, color;
  char key;
  bool Pause, Exposed, Resize;
  GraphMode gm;
};










