/***************************************************************************
                          dlgstartmenu.cpp  -  description
                             -------------------
    begin                : Sat Oct 23 1999
    copyright            : (C) 1999 by Rene Mrten, Christian Fricke
                           und Torsten Enkelmann
    email                : @-Mail to: delta_x@LinuxCoding.DE
                                      cfricke@LinuxCoding.DE
                                      Torsten@LinuxCoding.DE
****************************************************************************/

#include "dlgstartmenu.h"
#include <kfiledialog.h>

dlgStartmenu::dlgStartmenu(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	setMinimumSize(470,400);
	setMaximumSize(470,400);
	setCaption(i18n("Edit Start-Menu"));
	QListBox_2->hide();
	QListBox_3->hide();
	
	connect(QPushButton_1,SIGNAL(clicked()),this,SLOT(closeClicked()));
	connect(QPushButton_2,SIGNAL(clicked()),this,SLOT(delClicked()));
	connect(QPushButton_3,SIGNAL(clicked()),this,SLOT(newClicked()));
	connect(QPushButton_4,SIGNAL(clicked()),this,SLOT(browseClicked()));

	connect(QLineEdit_1,SIGNAL(returnPressed()),this,SLOT(titelReturn()));
	connect(QLineEdit_2,SIGNAL(returnPressed()),this,SLOT(appReturn()));
	connect(QLineEdit_3,SIGNAL(returnPressed()),this,SLOT(paramReturn()));
	
	connect(QLineEdit_1,SIGNAL(textChanged(const char *)),this,SLOT(titelEd(const char *)));
	connect(QLineEdit_2,SIGNAL(textChanged(const char *)),this,SLOT(appEd(const char *)));
	connect(QLineEdit_3,SIGNAL(textChanged(const char *)),this,SLOT(paramEd(const char *)));
	
	connect(QComboBox_1,SIGNAL(activated( const char * )),this,SLOT(comboActivated( const char * )));

	connect(QListBox_1,SIGNAL(highlighted(int)),this,SLOT(titelSelected(int)));
	connect(QListBox_2,SIGNAL(highlighted(int)),this,SLOT(appSelected(int)));
	connect(QListBox_3,SIGNAL(highlighted(int)),this,SLOT(paramSelected(int)));
	
	QPushButton_2->setEnabled(false);
	KConfig *config = kapp->getConfig();
	config->setGroup("Startmenu");
	QString s;
	bool flag=true;
	int i=0;
	while(flag)
	{
		s.sprintf("Menutitle%d",i);
		QString titel = config->readEntry(s,"");
		if(titel == "") break;
		QListBox_1->insertItem(titel);
		s.sprintf("MenuApp%d",i);
		titel = config->readEntry(s,"");
		QListBox_2->insertItem(titel);
		s.sprintf("MenuParam%d",i++);
		titel = config->readEntry(s,"");
		QListBox_3->insertItem(titel);
	}
	if(QListBox_1->count())
		QListBox_1->setCurrentItem(0);
}

dlgStartmenu::~dlgStartmenu(){
}


void dlgStartmenu::comboActivated( const char *s )
{
	if(strcmp(QLineEdit_3->text(),i18n("new Param")) == 0)
		QLineEdit_3->setText("");
	QString source(QLineEdit_3->text());
	QString ss(s);
	ss = ss.left(2) + " ";
	source.insert(QLineEdit_3->cursorPosition(),ss);
	QLineEdit_3->setText(source);
	QListBox_3->changeItem(source,QListBox_3->currentItem() );
	QLineEdit_1->setFocus();

}


void dlgStartmenu::closeClicked()
{
	save();
	this->accept();
}

void dlgStartmenu::closeEvent ( QCloseEvent * e )
{
	save();
	e->accept();
}
void dlgStartmenu::save()
{
	KConfig *config = kapp->getConfig();
	config->setGroup("Startmenu");
	QString s;
	unsigned int i;
	for(i = 0;i < QListBox_1->count();i++)
	{
		s.sprintf("Menutitle%d",i);
		config->writeEntry(s,QListBox_1->text(i));
		s.sprintf("MenuApp%d",i);
		config->writeEntry(s,QListBox_2->text(i));
		s.sprintf("MenuParam%d",i);
		config->writeEntry(s,QListBox_3->text(i));
	}
	s.sprintf("Menutitle%d",i);
	config->writeEntry(s,"");
}

void dlgStartmenu::delClicked()
{
	QListBox_2->removeItem(QListBox_2->currentItem());
	QListBox_3->removeItem(QListBox_3->currentItem());
	QListBox_1->removeItem(QListBox_1->currentItem());

	if(QListBox_1->count() == 0)
	{
		QLineEdit_1->setText("");
		QLineEdit_2->setText("");
		QLineEdit_3->setText("");
		QPushButton_2->setEnabled(false);
		return;
	}

}
void dlgStartmenu::newClicked()
{
	QListBox_2->insertItem(i18n("new App"));
	QListBox_3->insertItem(i18n("new Param"));
	QListBox_1->insertItem(i18n("new Entry"));
	QListBox_1->setCurrentItem(QListBox_1->count()-1);
}

void dlgStartmenu::titelEd(const char *text)
{
	if(QListBox_1->count())
		QListBox_1->changeItem(text,QListBox_1->currentItem() );
}

void dlgStartmenu::appEd(const char *text)
{
	if(QListBox_2->count())
		QListBox_2->changeItem(text,QListBox_2->currentItem() );
}

void dlgStartmenu::paramEd(const char *text)
{
	if(QListBox_3->count())
		QListBox_3->changeItem(text,QListBox_3->currentItem() );
}

void dlgStartmenu::titelSelected(int index)
{
		QPushButton_2->setEnabled(true);
		QLineEdit_1->setText(QListBox_1->text(index));
		QListBox_2->setCurrentItem(QListBox_1->currentItem());
		QListBox_3->setCurrentItem(QListBox_1->currentItem());
}
void dlgStartmenu::appSelected(int index)
{
		QLineEdit_2->setText(QListBox_2->text(index));
}
void dlgStartmenu::paramSelected(int index)
{
		QLineEdit_3->setText(QListBox_3->text(index));
}

void dlgStartmenu::browseClicked()
{
	
	QString s;
	KFileDialog *browseFile;
	browseFile = new KFileDialog("/");
	s = browseFile->getOpenFileName();
	
	if(s.length() != 0)
	{
		QLineEdit_2->setText(s);
		QListBox_2->changeItem(s,QListBox_2->currentItem() );
	}
}


void dlgStartmenu::titelReturn()
{
	QLineEdit_2->setFocus();
}
void dlgStartmenu::appReturn()
{
	QLineEdit_3->setFocus();
}
void dlgStartmenu::paramReturn()
{
	QLineEdit_1->setFocus();
}
