
#ifndef _MPROGRES_H
#define _MPROGRES_H

#include <qframe.h>
#include <qrangecontrol.h>

class myProgress : public QFrame, public QRangeControl {
	Q_OBJECT
public:
  enum Orientation { Horizontal, Vertical };
  enum BarStyle { Solid, Blocked };
  myProgress(QWidget *parent=0, const char *name=0);
  myProgress(Orientation, QWidget *parent=0, const char *name=0);
	myProgress(int minValue,int maxValue,int value, Orientation, 
				QWidget *parent=0, const char *name=0);
  ~myProgress();
  void setBarStyle(BarStyle style);  
  void setBarColor(const QColor &); 
  void setBarPixmap(const QPixmap &);
  void setOrientation(Orientation);
  void setTextEnabled(bool);
  BarStyle barStyle() const;
  const QColor &barColor() const;
  const QPixmap *barPixmap() const;
  Orientation orientation() const;
  bool textEnabled() const;
  virtual QSize sizeHint() const;
	void setValueRange(int,int);
public slots:
	void setValue(int);
	void advance(int);
signals:
	void percentageChanged(int);
protected:
	void valueChange();
	void rangeChange();
	void styleChange( GUIStyle );
	void paletteChange( const QPalette & );
	void drawContents( QPainter * );
	
private:
	QPixmap		*bar_pixmap;
	QColor		bar_color;
	QColor		bar_text_color;
	QColor		text_color;
	QRect fr;
	BarStyle	bar_style;
	Orientation orient;
	bool		text_enabled;
	void initialize();
	int recalcValue(int);
	void drawText(QPainter *);
	void adjustStyle();
};


#endif


