/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <kapp.h>
#include <kio_job.h>
#include "sitedef.h"
#include "toplevel.h"


// Lib idiocy
void openFileManagerWindow( const char * )
{}  


int main(int argc, char* argv[])
{ 
    KApplication app(argc, argv, "columbo");
    SiteDefinition::readSiteDefinitions();
    KIOJob::initStatic();
    
    if (app.isRestored())
	{ 
	    RESTORE(TopLevel);
	}
    else 
	{
	    TopLevel *t = new TopLevel();
	    app.setMainWidget(t);
	    t->show();
	}
    return app.exec();
}  
 

// Local Variables:
// c-basic-offset: 4
// End:












