/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <stdio.h>
#include <qbrush.h>
#include <qpainter.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kurl.h>
#include "resultview.h"


class ResultViewItem : public QListViewItem
{
public:
    ResultViewItem( QListView *parent, QString host, QString path,
		    QString size, QString date);
    virtual void setup();
    virtual const char *key(int col, bool ascending) const;
    virtual const char *text(int col) const;
    virtual void paintCell(QPainter *p, const QColorGroup &cg,
			   int col, int width, int align);

private:
    QString m_url;
    friend class ResultView;
};


ResultViewItem::ResultViewItem( QListView *parent, QString host, QString path,
				QString size, QString date)
    : QListViewItem(parent, host, path, size, date)
{
}

// Work around a Qt 1.x bug
void ResultViewItem::setup()
{
    QListViewItem::setup();
#if 0
    widthChanged(SiteColumn);
    QFontMetrics fm(listView()->fontMetrics());
    setHeight( fm.height() + 2*listView()->itemMargin() );
#endif
}


const char *ResultViewItem::key(int col, bool ascending) const
{
    return QListViewItem::key(col, ascending);
}


const char *ResultViewItem::text(int col) const
{
    return QListViewItem::text(col);
}       


void ResultViewItem::paintCell(QPainter *p, const QColorGroup &cg,
			       int col, int width, int align)
{
    QListViewItem::paintCell(p, cg, col, width, align);
}


ResultView::ResultView(QWidget *parent, const char *name)
    : QListView(parent, name)
{
    addColumn( i18n("Date") );
    addColumn( i18n("Size") );
    addColumn( i18n("Server") );
    addColumn( i18n("Path") );

    connect( this, SIGNAL(doubleClicked(QListViewItem*)),
	     SLOT(itemActivated(QListViewItem*)) );
#if 0
    connect( this, SIGNAL(selectionChanged(QListViewItem*)),
	     SLOT(itemSelected(QListViewItem*)) );
#endif
}

void ResultView::insertItem(QString host, QString path, QString size, QString date)
{
    (void) new ResultViewItem(this, date, size, host, path);
}


void ResultView::itemActivated(QListViewItem *item)
{
    emit urlActivated(static_cast<ResultViewItem*>(item)->m_url);
}

#if 0
void ResultView::itemSelected(QListViewItem *item)
{
    emit detailsActivated(static_cast<ResultViewItem*>(item)->m_details);
}
#endif


// Local Variables:
// c-basic-offset: 4
// End:
