/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <qregexp.h>
#include <stdlib.h>
#include "misc.h"
#include "sitejob.h"
#include "sitedef.h"


SiteJob::SiteJob(SiteDefinition *site)
{
    m_site = site;
    enableGUI(false);
    state = Begin;

    connect( this, SIGNAL(sigData(int,const char*,int)),
	     SLOT(gotData(int,const char*,int)) );
}


void SiteJob::query(QString searchtext)
{
    QString url = m_site->makeQueryUrl(searchtext);
    cout << "Fetching " << url << endl;
#if 1
    get(url); 
#endif
#if 0
    feedtest("/home/bernd/kdecvs1.1/columbo/colftp/ftp-search/ftpsearch-res.html");
#endif
}


void SiteJob::parseItem(QString item)
{
    QString host, path, size, date;
    int pos;
    cout << "Found:"<<item<<endl;
    QString raw = removeHTML(item).simplifyWhiteSpace();
    pos = raw.find(' ');
    if (pos == -1)
	return;
    host = raw.left(pos);
    raw.remove(0, pos+1);
    pos = raw.find(' ');
    if (pos == -1)
	return;
    path = raw.left(pos);
    raw.remove(0, pos+1);
    pos = raw.find(' ');
    if (pos == -1)
	return;
    size = raw.left(pos);
    raw.remove(0, pos+1);
    emit foundItem(host, path, size, raw);
}


void SiteJob::gotData(int, const char *data, int len)
{
    int pos, pos1, pos2;
    m_buf += QString(data, len);
 
    for (;;)
	{
	    switch (state)
		{
		case Begin:
		    if ( (pos = m_buf.find(m_site->resultListStart)) == -1)
			return;
		    //		    cout << "state -> ResultList" << endl;
		    state = ResultList;
		    m_buf.remove(0, pos+m_site->resultListStart.length());
		    break;
		case ResultList:
		    pos1 = m_buf.find(m_site->resultListEnd);
		    if (m_site->resultItemStart.isEmpty())
			pos2 = 0;
		    else
			pos2 = m_buf.find(m_site->resultItemStart);
		    if (pos1 == -1 && pos2 == -1)
			return;

		    if ( (pos1 != -1) && (pos2 == -1 || pos1 <= pos2) )
			{
			    //			    cout << "state -> End" << endl;
			    state = End;
			    return;
			}
		    if (pos2 == -1)
			return;
		    //		    cout << "state -> ResultItem" << endl;
		    state = ResultItem;
		    m_buf.remove(0, pos2);
		    break;
		case ResultItem:
		    if ( (pos = m_buf.find(m_site->resultItemEnd)) == -1)
			return;
		    //		    cout << "state -> ResultList" << endl;
		    state = ResultList;
		    parseItem(m_buf.left(pos));
		    m_buf.remove(0, pos+m_site->resultItemEnd.length());
		    break;
		default:
		    return;
		}
	}
}

#if 1
void SiteJob::feedtest(QString filename)
{
    char buf[512];
    FILE *f = fopen(filename, "r");
    if (!f)
	return;
    
    while (!feof(f))
	{
	    int n = fread(buf, 1, sizeof buf, f);
	    QString line = QString(buf, n);
	    // Feed the data in small chunks so we can see potential problems
	    while (line.length() != 0)
		{
		    int len = QMAX(20, line.length());
		    gotData(0, line.data(), len);
		    line.remove(0, len);
		}
	}
    fclose(f);
}
#endif

// Local Variables:
// c-basic-offset: 4
// End:

















