/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <kapp.h>
#include <kdir.h>
#include <ksimpleconfig.h>
#include "sitedef.h"
#include "misc.h"
#include <iostream.h>


QDict<SiteDefinition> SiteDefinition::map;


struct InputTag
{
    QString name;
    QString value;
    bool user;
};



QString SiteDefinition::makeQueryUrl(QString query)
{
    QString url = action;
    url += "?";
    QListIterator<InputTag> it(inputs);
    for (; it.current(); ++it)
	{
	    url += it.current()->name;
	    url += "=";
	    if (it.current()->user)
		url += encodeString(query);
	    else
		url += it.current()->value;
	    if (!it.atLast())
		url += "&";
	}
    return url;
}


void SiteDefinition::readSiteDefinitions()
{
    QDir dir(kapp->kde_datadir() + "/columbo/news-search/");
    dir.setFilter( QDir::Files );

    QStrListIterator it(*dir.entryList());
    for (; it.current(); ++it)
	{
	    QString filename = QString(dir.path()) + "/" + it.current();
	    cout << "Reading " << filename << endl;

	    QString name;
	    SiteDefinition *site = new SiteDefinition();
	    
	    KSimpleConfig config(filename, true);
	    config.setGroup("General");
	    name = config.readEntry("Name");
	    cout << "Name " << name << endl;
	    site->description = config.readEntry("Description");
	    cout << "Description " << site->description << endl;
	    site->action = config.readEntry("Action");
	    cout << "action " << site->action << endl;
	    site->icon = config.readEntry("Icon");
	    cout << "Icon " << site->icon << endl;
	    config.setGroup("Input");
	    int n = config.readUnsignedNumEntry("NumberOfInputs");
	    cout << "NumberOfInputs " << n << endl;
	    for (int i = 0; i < n; ++i)
		{
		    InputTag *tag = new InputTag();
		    QString s;
		    s.setNum(i);
		    s.prepend("InputName");
		    tag->name = config.readEntry(s);
		    cout << s << "(name) is " << tag->name;
		    s.setNum(i);
		    s.prepend("InputValue");
		    tag->value = config.readEntry(s);
		    cout << s << "(value) is " << tag->value;
		    s.setNum(i);
		    s.prepend("InputUser");
		    tag->user = config.readBoolEntry(s);
		    cout << s << "(user) is " << tag->user;
		    site->inputs.append(tag);
		}
	    config.setGroup("Interpret");
	    site->resultListStart = config.readEntry("resultListStart");
	    site->resultListEnd = config.readEntry("resultListEnd");
	    site->resultItemStart = config.readEntry("resultItemStart");
	    site->resultItemEnd = config.readEntry("resultItemEnd");
	    site->dateStart = config.readEntry("dateStart");
	    site->dateEnd = config.readEntry("dateEnd");
	    site->subjectStart = config.readEntry("subjectStart");
	    site->subjectEnd = config.readEntry("subjectEnd");
	    site->forumStart = config.readEntry("forumStart");
	    site->forumEnd = config.readEntry("forumEnd");
	    site->authorStart = config.readEntry("authorStart");
	    site->authorEnd = config.readEntry("authorEnd");
	    map.insert(name, site);
	}
}


// Local Variables:
// c-basic-offset: 4
// End:
