/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <qregexp.h>
#include <stdlib.h>
#include "misc.h"
#include "sitejob.h"
#include "sitedef.h"


SiteJob::SiteJob(SiteDefinition *site)
{
    m_site = site;
    enableGUI(false);
    state = Begin;

    connect( this, SIGNAL(sigData(int,const char*,int)),
	     SLOT(gotData(int,const char*,int)) );
}


void SiteJob::query(QString searchtext)
{
    QString url = m_site->makeQueryUrl(searchtext);
    cout << "Fetching " << url << endl;
#if 1
    get(url); 
#endif
#if 0
    if (url.find("altavista") != -1)
	feedtest("/home/bernd/kdecvs1.1/columbo/colweb/www-search/altavista-res.html");
    else
	feedtest("/home/bernd/kdecvs1.1/columbo/colweb/www-search/excite-res.html");
#endif
}


void SiteJob::parseItem(QString item)
{
    int pos1, pos2, pos3;
    QString url, name, relevstr;
    int relevance;

#if 0
    cout << "-----------------------------------------------------------" << endl;
    cout << "Parsing Item:" << item << "|" << endl;
    cout << "-----------------------------------------------------------" << endl;
#endif
    
    // This parser sucks.
    pos1 = item.find(QRegExp("<a href=", false));
    if (pos1 == -1)
	return;
    
    pos2 = item.find(">", pos1+8);
    if (pos2 == -1)
	return;
    
    pos3 = item.find(QRegExp("</a>", false), pos2+1);
    if (pos3 == -1)
	return;

    url = item.mid(pos1+8, pos2-(pos1+8)).stripWhiteSpace();
    if (url.left(1) == "\"")
	url.remove(0, 1);
    if (url.right(1) == "\"")
	url.remove(url.length()-1, 1);
    cout << "Url: " << url << endl;
    
    name = removeHTML(item.mid(pos2+1, pos3-(pos2+1)));
    if ( (pos3 = name.find('\n')) != -1)
	name.truncate(pos3);
    cout << "Name: " << name << endl;

    relevance = -1;
    if (!m_site->relevanceStart.isEmpty() && !m_site->relevanceEnd.isEmpty())
	{
	    pos1 = item.find(m_site->relevanceStart);
	    if (pos1 != -1)
		{
		    pos2 = item.find(m_site->relevanceEnd, pos1+1);
		    if (pos2 != -1)
			{
			    relevstr = item.mid(pos1+m_site->relevanceStart.length(),
						  pos2-(pos1+m_site->relevanceStart.length()));
			    pos3 = relevstr.find(QRegExp("[0-9]"));
			    if (pos3 != -1)
				{
				    relevstr.remove(0, pos3);
				    relevance = atoi(relevstr);
				    if (relevance > 100)
					relevance = -1;
				}
			}
		}
	}
    cout << "Relevance: " << relevance << endl;
    emit foundItem(m_site->icon, name, url, relevance, item);
}


void SiteJob::gotData(int, const char *data, int len)
{
    int pos;
    m_buf += QString(data, len);

    for (;;)
	{
	    switch (state)
		{
		case Begin:
		    if ( (pos = m_buf.find(m_site->resultListStart)) == -1)
			return;
#if 0
		    cout << "Begin -> ResultList" << endl;
#endif
		    state = ResultList;
		    m_buf.remove(0, pos+m_site->resultListStart.length());
		    break;
		case ResultList:
		    if ( (pos = m_buf.find(m_site->resultItemStart)) == -1)
			return;
#if 0
		    cout << "ResultList -> ResultItem" << endl;
#endif
		    state = ResultItem;
		    m_buf.remove(0, pos+m_site->resultItemStart.length());
		    break;
		case ResultItem:
		    if ( (pos = m_buf.find(m_site->resultItemEnd)) == -1)
			return;
#if 0
		    cout << "ResultItem -> ResultList" << endl;
#endif
		    state = ResultList;
		    parseItem(m_buf.left(pos));
		    m_buf.remove(0, pos);
		    break;
		default:
		    break;
		}
	}
}

#if 1
void SiteJob::feedtest(QString filename)
{
    char buf[512];
    FILE *f = fopen(filename, "r");
    if (!f)
	return;
    
    while (fgets(buf, sizeof buf, f))
	{
	    QString line = buf;
	    // Feed the data in small chunks so we can see potential problems
	    while (line.length() != 0)
		{
		    int len = QMAX(5, line.length());
		    gotData(0, line.data(), len);
		    line.remove(0, len);
		}
	}
    fclose(f);
}
#endif

// Local Variables:
// c-basic-offset: 4
// End:

















